#if !defined(AFX_RWWRAPPER_H__EE4327DD_44E5_44F4_A845_2B04A1EA9843__INCLUDED_)
#define AFX_RWWRAPPER_H__EE4327DD_44E5_44F4_A845_2B04A1EA9843__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// RWWrapper.h : header file
//

#include "rwcore.h"		// renderware core
#include "rt2d.h"
#include "rtcharse.h"
#include "rtpng.h"		// PNG tool
#include "rpworld.h"	// renderware world plugin
#include "rplodatm.h"
#include "rpmorph.h"	// renderware morph plugin
#include "rpskin.h"		// renderware skin plugin
#include "rphanim.h"
#include "rpmatfx.h"
#include "rpspline.h"

//#include "PGLWad.h"
#include "StreamReaderAscii.h"
#include "tga.h"		// targa image loader



/////////////////////////////////////////////////////////////////////////////
// RWWrapper command target

#define MAX_WAD_RESOURCES 1000

	typedef enum
  	{
  		UNKNOWN = 0,
  		CHARACTER,
  		OBJECT,
  		RWBSP,
  		COLLISION,
  		ANIMATION
   	} eWadType;

//class RWWrapper : public CCmdTarget
class RWWrapper : public CObject
{
	DECLARE_DYNCREATE(RWWrapper)

	friend class CPGLWadApp;  // Declare a friend class

	RWWrapper();           // protected constructor used by dynamic creation
	virtual ~RWWrapper();

// Attributes
public:

	#define DVD_SECTOR_SIZE 2048

	typedef struct tagWAD_HEADER
	{
		u32 numberOfResources;		// all resources - animations
		u32 numberOfAnimations;		// animations
		u32 currentWadPos;			// current file position within Wad

		u32 resourceLengthArray[MAX_WAD_RESOURCES];
		u32 resourceOffsetArray[MAX_WAD_RESOURCES];

	} WAD_HEADER;

	typedef struct tagWAD_BODY_HEADER
	{
		u32		 type;
		char     resourceName[16];
		u32      lengthOfData; 

	} WAD_BODY_HEADER;

protected:

	RwTexDictionary * m_pTextureDictionary;
    char * m_pSummaryFile;
    KMemoryArchiveReader* m_pMemoryArchiveReader;
	StreamReaderAscii* m_pStreamReaderAscii;
    unsigned int m_workBufferCurrentPos;
	unsigned int m_numberOfResourcesInBuffer;
	WAD_HEADER m_wadHeader;
	WAD_BODY_HEADER m_wadBodyHeader;
	unsigned int m_workBufferSize;
	unsigned char * m_pRWStreamData;

//	unsigned int m_numberOfResources;
//	unsigned int m_currentResource;
//	unsigned int m_numberOfAnimations;
//	unsigned int m_currentAnimation;
	KArchive * m_currentWad;
	RwTexDictionary * m_TextureDictionary;

// Operations
public:

	bool initialize();
	bool close();
	bool addDirectoryToDictionary(KGString & imagePath);

	bool DetermineTXDname(KGString & level);
	bool createTextureDictionary(KString & level);
	bool createTextureDictionaryFromDff(KString & level);
	bool saveTextureDictionary(KString& level);
	bool createRWWadd(KString & level);
	bool loadSummaryFile (KString& level);
	unsigned int fillWorkBuffer();
	eWadType getType (char *&resourceName);

	bool openWadFile(KString & level);
	bool appendWadFile(KString & level);
	bool closeWadFile(KString & level);
	bool addWadHeader(KString & level);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(RWWrapper)
	//}}AFX_VIRTUAL

// Implementation
protected:
//	virtual ~RWWrapper();

	// Generated message map functions
	//{{AFX_MSG(RWWrapper)
		// NOTE - the ClassWizard will add and remove member functions here.
	//}}AFX_MSG

//	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_RWWRAPPER_H__EE4327DD_44E5_44F4_A845_2B04A1EA9843__INCLUDED_)
