/****************************************************************************
 *                                                                          *
 * module : ps2alldbg.h                                                     *
 *                                                                          *
 * purpose: REDEBUG printf macros, kept in here to reduce clutter           *
 *                                                                          *
 ****************************************************************************/

#ifndef PS2ALLDBG_H
#define PS2ALLDBG_H

#include "nodeps2all.h"


/****************************************************************************
 Global defines
 */

/* Sub-macros cos we can't put #defines inside macros :o/ */
#if (defined(FASTMORPH))
#define FMPRED(args) (args)
#else /* (defined(FASTMORPH)) */
#define FMPRED(args) /* no op */
#endif /* (defined(FASTMORPH)) */


/* General-purpose clutter-reducing macro */

#if (defined(REDEBUG))
#define REDEBUGPrintf(args) (printf(args))
#else /* (defined(REDEBUG)) */
#define REDEBUGPrintf(args) /* no op */
#endif /* (defined(REDEBUG)) */

/* ========= MATINSTANCE ========= */

/* RabinsConstructionTimeCode */
#if (defined(REDEBUG))
#define REDEBUGConstructionTimeMacro()                                       \
MACRO_START                                                                  \
{                                                                            \
    /* dump pvtData to stdout */                                             \
    {                                                                        \
        int i,j;                                                             \
        int ze = 0;                                                          \
        volatile int *vol = &ze;                                             \
                                                                             \
        printf("rwPS2MatInstancePvtData generated by ");                     \
        printf("RabinsConstructionTimeCode:\n");                             \
        /*printf(" breakoutsbitfield = %08x\n",                              \
          pvtData->breakoutsbitfield);*/                                     \
        printf(" totallyOpaque = %d\n",                                      \
               pvtData->totallyOpaque);                                      \
        printf(" numStripes = %d\n",                                         \
               pvtData->numStripes);                                         \
        printf(" sizeOnVU = %d\n",                                           \
               pvtData->sizeOnVU);                                           \
        printf(" clinfo:\n");                                                \
        for (i = 0; i< ((int)(CL_MAXCL)); i++)                               \
        {                                                                    \
            printf("  Cluster %d\n", i);                                     \
            /*printf("  cliIndex %d\n", pvtData->clinfo[i].cliIndex);*/      \
            printf("  attrib %08x\n", pvtData->clinfo[i].attrib);            \
            /*printf("  cluster %p\n", pvtData->clinfo[i].cluster);*/        \
            /* We put a pause in here as                                     \
             * dsnetm has a buffer overrun problem */                        \
            for (j=0; j<100000; j++)                                         \
            {                                                                \
                if (*vol)                                                    \
                {                                                            \
                    printf("Odd?\n");                                        \
                }                                                            \
            }                                                                \
        }                                                                    \
        if (pointList == FALSE);                                             \
        {                                                                    \
            printf(" triStrip:\n");                                          \
            printf("  batchSize %d\n",                                       \
                   pvtData->triStrip.batchSize);                             \
            printf("  batchesPerTag %d\n",                                   \
                   pvtData->triStrip.batchesPerTag);                         \
            FMPRED((printf("  morphBatchSize %d\n",                          \
                           pvtData->triStrip.morphBatchSize)));              \
            FMPRED((printf("  morphBatchesPerTag %d\n",                      \
                           pvtData->triStrip.morphBatchesPerTag)));          \
            for (i = 0; i< ((int)(CL_MAXCL + FMADD)); i++)                   \
            {                                                                \
                printf("   fieldRec %d\n", i);                               \
                printf("   numVerts %d\n",                                   \
                       pvtData->triStrip.fieldRec[i].numVerts);              \
                FMPRED((printf("   morphNumVerts %d\n",                      \
                               pvtData->triStrip.fieldRec[i].morphNumVerts)));          \
                printf("   dataoffset %d\n",                                 \
                       pvtData->triStrip.fieldRec[i].dataoffset);            \
                FMPRED((printf("   morphDataoffset %d\n",                    \
                               pvtdata->triStrip.fieldRec[i].morphDataoffset)));        \
                printf("   skip %d\n",                                       \
                       pvtData->triStrip.fieldRec[i].skip);                  \
                FMPRED((printf("   morphSkip %d\n",                          \
                               pvtData->triStrip.fieldRec[i].morphSkip)));   \
                printf("   vuoffset %d\n",                                   \
                       pvtData->triStrip.fieldRec[i].vuoffset);              \
                /* We put a pause in here as dsnetm has                      \
                 * a buffer overrun problem */                               \
                for (j=0; j<100000; j++)                                     \
                {                                                            \
                    if (*vol)                                                \
                    {                                                        \
                        printf("Odd?\n");                                    \
                    }                                                        \
                }                                                            \
            }                                                                \
        }                                                                    \
                                                                             \
        if (pointList == FALSE)                                              \
        {                                                                    \
            printf(" triList:\n");                                           \
        }                                                                    \
        else                                                                 \
        {                                                                    \
            printf(" pointList:\n");                                         \
        }                                                                    \
        printf("  batchSize %d\n",                                           \
               pvtData->triList.batchSize);                                  \
        printf("  batchesPerTag %d\n",                                       \
               pvtData->triList.batchesPerTag);                              \
        FMPRED((printf("  morphBatchSize %d\n",                              \
                       pvtData->triList.morphBatchSize)));                   \
        FMPRED((printf("  morphBatchesPerTag %d\n",                          \
                       pvtData->triList.morphBatchesPerTag)));               \
        for (i = 0; i< ((int)(CL_MAXCL + FMADD)); i++)                       \
        {                                                                    \
            printf("   fieldRec %d\n", i);                                   \
            printf("   numVerts %d\n",                                       \
                   pvtData->triList.fieldRec[i].numVerts);                   \
            FMPRED((printf("   morphNumVerts %d\n",                          \
                           pvtData->triList.fieldRec[i].morphNumVerts)));    \
            printf("   dataoffset %d\n",                                     \
                   pvtData->triList.fieldRec[i].dataoffset);                 \
            FMPRED((printf("   morphDataoffset %d\n",                        \
                           pvtdata->triList.fieldRec[i].morphDataoffset)));  \
            printf("   skip %d\n",                                           \
                   pvtData->triList.fieldRec[i].skip);                       \
            FMPRED((printf("   morphSkip %d\n",                              \
                           pvtData->triList.fieldRec[i].morphSkip)));        \
            printf("   vuoffset %d\n",                                       \
                   pvtData->triList.fieldRec[i].vuoffset);                   \
            /* We put a pause in here as dsnetm has                          \
             * a buffer overrun problem */                                   \
            for (j=0; j<100000; j++)                                         \
            {                                                                \
                if (*vol)                                                    \
                {                                                            \
                    printf("Odd?\n");                                        \
                }                                                            \
            }                                                                \
        }                                                                    \
    }                                                                        \
}                                                                            \
MACRO_STOP

#else /* (defined(REDEBUG)) */
#define REDEBUGConstructionTimeMacro() /* no op */
#endif /* (defined(REDEBUG)) */


/* _rwRabinsMatInstanceCode */
#if (defined(REDEBUG))
#define REDEBUGCacheResEntryStructureMacro()                  \
MACRO_START                                                   \
{                                                             \
    printf("We cache the old sizes etc:\n");                  \
    printf(" size %d\n", size);                               \
    printf(" batchSize %d\n", batchSize);                     \
    printf(" batchesPerTag %d\n", batchesPerTag);             \
    {                                                         \
        int ze = 0;                                           \
        volatile int *vol = &ze;                              \
                                                              \
        for (i = 0; i < (CL_MAXCL + FMADD); i++)              \
        {                                                     \
            printf(" fieldRec %d\n", i);                      \
            printf("  numVerts %d\n", fieldRec[i].numVerts);  \
            FMPRED((printf("  morphNumVerts %d\n", fieldRec[i].morphNumVerts)));        \
            printf("  dataoffset %d\n", fieldRec[i].dataoffset);                        \
            FMPRED((printf("  morphDataoffset %d\n", fieldRec[i].morphDataoffset)));    \
            printf("  skip %d\n", fieldRec[i].skip);          \
            printf("  reverse %d\n", fieldRec[i].reverse);    \
            printf("  vuoffset %d\n", fieldRec[i].vuoffset);  \
            /* We put a pause in here as dsnetm has a buffer overrun problem */         \
            for (j=0; j<100000; j++)                          \
            {                                                 \
                if (*vol)                                     \
                {                                             \
                    printf("Odd?\n");                         \
                }                                             \
            }                                                 \
        }                                                     \
    }                                                         \
}                                                             \
MACRO_STOP
#else /* (defined(REDEBUG)) */
#define REDEBUGCacheResEntryStructureMacro() /* no op */
#endif /* (defined(REDEBUG)) */


#if (defined(REDEBUG))
#define REDEBUGResHeaderMacro()                                    \
MACRO_START                                                        \
{                                                                  \
        printf("ps2ResHeader:\n");                                 \
        printf(" refCnt %d\n", ps2ResHeader->refCnt);              \
        printf(" clrCnt %d\n", ps2ResHeader->clrCnt);              \
        printf(" data %p\n", ps2ResHeader->data);                  \
        printf(" serialNum %d\n", (RwUInt32)ps2ResHeader->serialNum);                                   \
        printf(" overloadFlags %d\n", (RwUInt32)ps2ResHeader->overloadFlags);                           \
        printf(" numVerts %d\n", ps2ResHeader->numVerts);          \
        printf(" batchSize %d\n", ps2ResHeader->batchSize);        \
        printf(" batchesPerTag %d\n", ps2ResHeader->batchesPerTag);                                     \
        FMPRED((printf(" numMorphTargets %d\n", ps2ResHeader->numMorphTargets)));                       \
        FMPRED((printf(" morphStart %d\n", ps2ResHeader->morphStart)));                                 \
        FMPRED((printf(" morphFinish %d\n", ps2ResHeader->morphFinish)));                               \
        FMPRED((printf(" morphNum %d\n", ps2ResHeader->morphNum)));                                     \
        {                                                          \
            int ze = 0;                                            \
            volatile int *vol = &ze;                               \
                                                                   \
            for (i = 0; i < (CL_MAXCL + FMADD); i++)               \
            {                                                      \
                printf(" fieldRec %d\n", i);                       \
                printf("  numVerts %d\n", ps2ResHeader->fieldRec[i].numVerts);                          \
                FMPRED((printf("  morphNumVerts %d\n", ps2ResHeader->fieldRec[i].morphNumVerts)));      \
                printf("  dataoffset %d\n", ps2ResHeader->fieldRec[i].dataoffset);                      \
                FMPRED((printf("  morphDataoffset %d\n", ps2ResHeader->fieldRec[i].morphDataoffset)));  \
                printf("  skip %d\n", ps2ResHeader->fieldRec[i].skip);                                  \
                FMPRED((printf("  morphSkip %d\n", ps2ResHeader->fieldRec[i].morphSkip)));              \
                printf("  reverse %d\n", ps2ResHeader->fieldRec[i].reverse);                            \
                printf("  vuoffset %d\n", ps2ResHeader->fieldRec[i].vuoffset);                          \
                /* We put a pause in here as dsnetm has a buffer overrun problem */                     \
                for (j=0; j<100000; j++)                           \
                {                                                  \
                    if (*vol)                                      \
                    {                                              \
                        printf("Odd?\n");                          \
                    }                                              \
                }                                                  \
            }                                                      \
        }                                                          \
}
MACRO_STOP
#else /* (defined(REDEBUG)) */
#define REDEBUGResHeaderMacro() /* no op */
#endif /* (defined(REDEBUG)) */


#if (defined(REDEBUG))
#if (defined(DMADUMP))
#define REDEBUGDMADumpMacro()                                                           \
MACRO_START                                                                             \
{                                                                                       \
    /* dump the entire structure to stdout */                                           \
    {                                                                                   \
        int j;                                                                          \
        int ze = 0;                                                                     \
        volatile int *vol = &ze;                                                        \
        u_long128 *ptr;                                                                 \
        u_long128 *finaladdr;                                                           \
                                                                                        \
        finaladdr = data;                                                               \
        printf("Final addr = %p (size = %d qws)\n",                                     \
               finaladdr, finaladdr - ps2ResHeader->data);                              \
                                                                                        \
        /* Now dump the data */                                                         \
        ptr = ps2ResHeader->data;                                                       \
        for (;(int)ptr < finaladdr; ptr++)                                              \
        {                                                                               \
            printf("%x: %.16lx %.16lx\n", (int)ptr, *((long *)ptr + 1), *(long *)ptr);  \
            /* We put a pause in here as dsnetm has a buffer overrun problem */         \
            for (j = 0; j < 100000; j++)                                                \
            {                                                                           \
                if (*vol)                                                               \
                {                                                                       \
                    printf("Odd?\n");                                                   \
                }                                                                       \
            }                                                                           \
                                                                                        \
        }                                                                               \
    }                                                                                   \
}                                                                                       \
MACRO_STOP
#endif /* (defined(DMADUMP)) */
#endif /* (defined(REDEBUG)) */
#if (!defined(REDEBUGDMADumpMacro))
#define REDEBUGDMADumpMacro() /* no op */
#endif /* (!defined(REDEBUGDMADumpMacro)) */


#if (defined(CLEARMEM))
#define CLEARMEMResEntryClearMacro()                            \
MACRO_START                                                     \
{                                                               \
    /* We clear memory to a value which is a VIF NOP, with a */ \
    /* stamp value in the bottom 16 bits */                     \
    unsigned int *ptr;                                          \
    unsigned int *ptrEnd;                                       \
                                                                \
    ptr = (unsigned int *)(*repEntry + 1);                      \
    ptrEnd = (unsigned int *)((char *)(*repEntry + 1) + size);  \
    while (ptr < ptrEnd)                                        \
        *ptr++ = (unsigned int)clearMemVal;                     \
    clearMemVal++;                                              \
}                                                               \
MACRO_STOP
#else /* (defined(CLEARMEM)) */
#define CLEARMEMResEntryClearMacro() /* no op */
#endif /* (defined(CLEARMEM)) */


/* DMADataSizeRecalc */
#if (defined(REDEBUG))
#define REDEBUGDMADataSizeRecalcMacro()                                                 \
MACRO_START                                                                             \
{                                                                                       \
    printf("batchSize %d\n", batchSize);                                                \
    printf("batchesPerTag %d\n", batchesPerTag);                                        \
    printf("numBatches %d\n", numBatches);                                              \
    printf("effectiveTotalVerts %d\n", effectiveTotalVerts);                            \
    {                                                                                   \
        int ze = 0;                                                                     \
        volatile int *vol = &ze;                                                        \
                                                                                        \
        for (i = 0; i < CL_MAXCL + FMADD; i++)                                          \
        {                                                                               \
            printf(" fieldRec %d\n", i);                                                \
            printf("  numVerts %d\n", fieldRec[i].numVerts);                            \
            FMPRED((printf("  morphNumVerts %d\n", fieldRec[i].morphNumVerts)));        \
            printf("  dataoffset %d\n", fieldRec[i].dataoffset);                        \
            FMPRED((printf("  morphDataoffset %d\n", fieldRec[i].morphDataoffset)));    \
            printf("  skip %d\n", fieldRec[i].skip);                                    \
            FMPRED((printf("  morphSkip %d\n", fieldRec[i].morphSkip)));                \
            printf("  vuoffset %d\n", fieldRec[i].vuoffset);                            \
            /* We put a pause in here as dsnetm has a buffer overrun problem */         \
            for (j=0; j<100000; j++)                                                    \
            {                                                                           \
                if (*vol)                                                               \
                {                                                                       \
                    printf("Odd?\n");                                                   \
                }                                                                       \
            }                                                                           \
        }                                                                               \
    }                                                                                   \
}                                                                                       \
MACRO_STOP
#else /* (defined(REDEBUG)) */
#define REDEBUGDMADataSizeRecalcMacro() /* no op */
#endif /* (defined(REDEBUG)) */


/* Object-specific reinstance funcs */

#if (defined(REDEBUG))
#if (defined(DMADUMPDATA))
#define REDEBUGObjectDMADumpMacro()                                             \
MACRO_START                                                                     \
{                                                                               \
    /* dump the entire structure to stdout */                                   \
    u_long128 *ptr, *endPtr;                                                    \
    RwUInt32 ze = 0;                                                            \
    volatile RwUInt32 *vol = &ze;                                               \
                                                                                \
    endPtr = (u_long128 *)((RwUInt8 *)ps2ResHeader +                            \
                           ((RwResEntry *)ps2ResHeader - 1)->size);             \
                                                                                \
    /* Now dump the data */                                                     \
    for (ptr = ps2ResHeader->data; ptr < endPtr; ptr++)                         \
    {                                                                           \
        printf("%x: %.16lx %.16lx\n",                                           \
               (RwUInt32)ptr, *((RwUInt64 *)ptr+1), *(RwUInt64 *)ptr);          \
        /* We put a pause in here as dsnetm has a buffer overrun problem */     \
        for (j=0; j<100000; j++)                                                \
        {                                                                       \
            if (*vol)                                                           \
            {                                                                   \
                printf("Odd?\n");                                               \
            }                                                                   \
        }                                                                       \
    }                                                                           \
}                                                                               \
MACRO_STOP
#endif /* (defined(DMADUMPDATA)) */
#endif /* (defined(REDEBUG)) */
#if (!defined(REDEBUGObjectDMADumpMacro))
#define REDEBUGObjectDMADumpMacro() /* no op */
#endif /* (!defined(REDEBUGObjectDMADumpMacro)) */


#endif /* PS2ALLDBG_H */
