
/****************************************************************************
 *                                                                          *
 * module : nodeps2matbridge.h                                              *
 *                                                                          *
 * purpose: see nodeps2matbridge.c                                          *
 *                                                                          *
 ****************************************************************************/

#ifndef NODEPS2MATBRIDGE_H
#define NODEPS2MATBRIDGE_H

#include <rwcore.h>

#include "wrldpipe.h"


/****************************************************************************
 global prototypes
 */

/* RWPUBLIC */

#ifdef __cplusplus
extern              "C"
{
#endif                          /* __cplusplus */

/* RWPUBLICEND */

extern const void  *skyUploadedCode;
extern void        *skyVU1Transforms[VU1CODEARRAYSIZE];
/* steal this from basky.c */
extern RwBool _rwSkySetRenderState(RwRenderState nState, void *param);

/* RWPUBLIC */



extern RxNodeDefinition *
RxNodeDefinitionGetPS2MatBridge(void);

/* These are for use after RxPipelineUnlock() */

extern RxPipelineNode *
RxPipelineNodePS2MatBridgeSetVU1CodeArray(RxPipelineNode * self,
                                          void **VU1CodeArray);

extern const void **
RxPipelineNodePS2MatBridgeGetVU1CodeArray(RxPipelineNode *self);

extern RxPipelineNode *
RxPipelineNodePS2MatBridgeSetVIFOffset(RxPipelineNode * self,
                                       int vifOffset);

extern RxPipelineNode *
RxPipelineNodePS2MatBridgeNoTexture(RxPipelineNode * self,
                                    RwBool noTexture);

/* LEGACY-SUPPORT macros for old API func names */

#define RxNodePS2MatBridgeGetVU1CodeArray \
        RxPipelineNodePS2MatBridgeGetVU1CodeArray

#define RxNodePS2MatBridgeSetVU1CodeArray \
        RxPipelineNodePS2MatBridgeSetVU1CodeArray

#define RxNodePS2MatBridgeSetVIFOffset \
        RxPipelineNodePS2MatBridgeSetVIFOffset

#define RxNodePS2MatBridgeNoTexture \
        RxPipelineNodePS2MatBridgeNoTexture

#define RxBridgeNodeSetVIFOffset(_self, _vifOffset)       \
        RxPipelineNodePS2MatBridgeSetVIFOffset(_self, _vifOffset)

#define RxBridgeNodeSetVU1CodeArray(_self, _VU1CodeArray) \
        RxPipelineNodePS2MatBridgeSetVU1CodeArray(_self, _VU1CodeArray)

/* RWPUBLICEND */

/* These exposed so nodePS2Manager can get at them */

typedef struct rwPS2MatBridgePvtData rwPS2MatBridgePvtData;
struct rwPS2MatBridgePvtData
{
        int                 vifOffset; /**< Internal Use */
        void              **VU1CodeArray; /**< Internal Use */
        RwBool              noTexture; /**< Internal Use */
};

extern RwBool
_rwPS2MatBridgePipelineNodeInit(RxPipelineNode *  self);

extern RwBool
_rwRabinsBridgeNodeCode(const RxPS2DMASessionRecord * DMASessionRecord,
                        const RxPS2Mesh * Mesh,
                        rwPS2MatBridgePvtData * pvtdata);

/* RWPUBLIC */
#ifdef    __cplusplus
}
#endif                          /* __cplusplus */

/* RWPUBLICEND */

#endif                          /* NODEPS2MATBRIDGE_H */
