/* INTEL
 *
 * Intel plug-in
 */

#include <stdio.h>
#include <stdlib.h>

#include "rpplugin.h"
#include "rpdbgerr.h"
#include "rtintel.h"

/**
 * \page rtinteloverview RtIntel Overview
 * \ingroup rtintel
 *
 * Intel specific support/simulation
 * 
 * The Intel Architecture evolves with the addition of new generations
 * and models of processors such as Pentium III and Pentium 4
 * processors, providing increasingly sophisticated processing capabilities
 * such as the SIMD MMX/SSE instruction sets for vector processing
 * 
 * The RtIntel toolkit provides both functionality to
 * - identify the x86 features supported by the host processor, 
 *    such as whether the MMX/SSE instruction sets are supported; see also
 *    -# AP-485 Intel Processor Identification and the CPUID Instruction<br>
 *    http://www.intel.com/design/pentiumii/applnots/241618.htm
 * 
 * - simulate the MMX/SSE instruction sets, e.g. for
 *     when the host x86 processor does not support these, or
 *     indeed to facilitate debugging/development of MMX/SSE
 *     specific code if it does; see also
 *     -# Internet Streaming SIMD Extensions<br>
 *      http://developer.intel.com/design/PentiumIII/prodbref/#Streaming
 *     -# Intel Streaming SIMD Extensions Application Notes<br>
 *       http://developer.intel.com/vtune/cbts/strmsimd/appnotes.htm
 */

#if (!defined(DOXYGEN))
static const char __RWUNUSED__ rcsid[] =
    "@@(#)$Id: rtintel.c,v 1.8 2001/06/12 08:55:15 johns Exp $";
#endif /* (!defined(DOXYGEN)) */

#if (defined(RWDEBUG))
long                rpIntelStackDepth = 0;
#endif /* (defined(RWDEBUG)) */
