/*
 * topic Bezier patch library
 *
 * This library provides effcient evaluation of
 * Cubic Bezier patches
 */

#include <stdarg.h>
#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>

#include <rwcore.h>
#include <rpdbgerr.h>

#include "rtbezpat.h"
#include "beztri.h"

static const char   rcsid[] __RWUNUSED__ =
    "@@(#)$Id: beztri.c,v 1.10 2001/10/05 09:18:28 rburg Exp $";

#define RtBezierTriMatrixControlFitMacro(_B, _P)                        \
MACRO_START                                                             \
{                                                                       \
    const RtBezierV4d        * const P0 = &(_P)[0][0];                  \
    const RtBezierV4d        * const P1 = &(_P)[1][0];                  \
    const RtBezierV4d        * const P2 = &(_P)[2][0];                  \
    const RtBezierV4d        * const P3 = &(_P)[3][0];                  \
    RtBezierV4d              * const B0 = &(_B)[0][0];                  \
    RtBezierV4d              * const B1 = &(_B)[1][0];                  \
    RtBezierV4d              * const B2 = &(_B)[2][0];                  \
    RtBezierV4d              * const B3 = &(_B)[3][0];                  \
                                                                        \
                                                                        \
    B0[0].x = P0[0].x;                                                  \
    B0[0].y = P0[0].y;                                                  \
    B0[0].z = P0[0].z;                                                  \
                                                                        \
    B0[1].x =                                                           \
        3 * P0[1].x - 5 * P0[0].x / 6 - 3 * P0[2].x / 2 + P0[3].x / 3;  \
    B0[1].y =                                                           \
        3 * P0[1].y - 5 * P0[0].y / 6 - 3 * P0[2].y / 2 + P0[3].y / 3;  \
    B0[1].z =                                                           \
        3 * P0[1].z - 5 * P0[0].z / 6 - 3 * P0[2].z / 2 + P0[3].z / 3;  \
                                                                        \
    B0[2].x =                                                           \
        P0[0].x / 3 - 3 * P0[1].x / 2 + 3 * P0[2].x - 5 * P0[3].x / 6;  \
    B0[2].y =                                                           \
        P0[0].y / 3 - 3 * P0[1].y / 2 + 3 * P0[2].y - 5 * P0[3].y / 6;  \
    B0[2].z =                                                           \
        P0[0].z / 3 - 3 * P0[1].z / 2 + 3 * P0[2].z - 5 * P0[3].z / 6;  \
                                                                        \
    B0[3].x = P0[3].x;                                                  \
    B0[3].y = P0[3].y;                                                  \
    B0[3].z = P0[3].z;                                                  \
                                                                        \
    B1[0].x =                                                           \
        3 * P1[0].x - 5 * P0[0].x / 6 - 3 * P2[0].x / 2 + P3[0].x / 3;  \
    B1[0].y =                                                           \
        3 * P1[0].y - 5 * P0[0].y / 6 - 3 * P2[0].y / 2 + P3[0].y / 3;  \
    B1[0].z =                                                           \
        3 * P1[0].z - 5 * P0[0].z / 6 - 3 * P2[0].z / 2 + P3[0].z / 3;  \
                                                                        \
    B1[1].x =                                                           \
        P0[0].x / 3 - 3 * P0[1].x / 4 - 3 * P0[2].x / 4 + P0[3].x / 3 - \
        3 * P1[0].x / 4 + 9 * P1[1].x / 2 - 3 * P1[2].x / 4 -           \
        3 * P2[0].x / 4 - 3 * P2[1].x / 4 + P3[0].x / 3;                \
    B1[1].y =                                                           \
        P0[0].y / 3 - 3 * P0[1].y / 4 - 3 * P0[2].y / 4 + P0[3].y / 3 - \
        3 * P1[0].y / 4 + 9 * P1[1].y / 2 - 3 * P1[2].y / 4 -           \
        3 * P2[0].y / 4 - 3 * P2[1].y / 4 + P3[0].y / 3;                \
    B1[1].z =                                                           \
        P0[0].z / 3 - 3 * P0[1].z / 4 - 3 * P0[2].z / 4 + P0[3].z / 3 - \
        3 * P1[0].z / 4 + 9 * P1[1].z / 2 - 3 * P1[2].z / 4 -           \
        3 * P2[0].z / 4 - 3 * P2[1].z / 4 + P3[0].z / 3;                \
                                                                        \
    B1[2].x =                                                           \
        3 * P1[2].x - 5 * P0[3].x / 6 - 3 * P2[1].x / 2 + P3[0].x / 3;  \
    B1[2].y =                                                           \
        3 * P1[2].y - 5 * P0[3].y / 6 - 3 * P2[1].y / 2 + P3[0].y / 3;  \
    B1[2].z =                                                           \
        3 * P1[2].z - 5 * P0[3].z / 6 - 3 * P2[1].z / 2 + P3[0].z / 3;  \
                                                                        \
    B2[0].x =                                                           \
        P0[0].x / 3 - 3 * P1[0].x / 2 + 3 * P2[0].x - 5 * P3[0].x / 6;  \
    B2[0].y =                                                           \
        P0[0].y / 3 - 3 * P1[0].y / 2 + 3 * P2[0].y - 5 * P3[0].y / 6;  \
    B2[0].z =                                                           \
        P0[0].z / 3 - 3 * P1[0].z / 2 + 3 * P2[0].z - 5 * P3[0].z / 6;  \
                                                                        \
    B2[1].x =                                                           \
        P0[3].x / 3 - 3 * P1[2].x / 2 + 3 * P2[1].x - 5 * P3[0].x / 6;  \
    B2[1].y =                                                           \
        P0[3].y / 3 - 3 * P1[2].y / 2 + 3 * P2[1].y - 5 * P3[0].y / 6;  \
    B2[1].z =                                                           \
        P0[3].z / 3 - 3 * P1[2].z / 2 + 3 * P2[1].z - 5 * P3[0].z / 6;  \
                                                                        \
    B3[0].x = P3[0].x;                                                  \
    B3[0].y = P3[0].y;                                                  \
    B3[0].z = P3[0].z;                                                  \
}                                                                       \
MACRO_STOP

/**
 * \ingroup rtbezpatch
 * \ref RtBezierTriMatrixControlFit returns the control points 
 * for a Bezier triangle fitted to pass through the supplied 
 * sample points
 *
 * \param B    Output Bezier control point matrix
 * \param P    Input sample point matrix
 */
void
RtBezierTriMatrixControlFit(RtBezierMatrix B, RtBezierMatrix P)
{
    RWAPIFUNCTION(RWSTRING("RtBezierTriMatrixControlFit"));
    RtBezierTriMatrixControlFitMacro(B, P);
    RWRETURNVOID();
}
