// ----------------------------------------------------------------------
// Warning: This file will be processed using a rather simple sed script
// to turn it into a C include file.
//
// sed -e "s/\([^;]*\);/\1\/\//"					\
//     -e "s/^\.if/#if/" -e "s/^\.else/#else/" -e "s/^\.endif/#endif/"	\
//     -e "s/^\.equ\([   ][^,]*\),/#define\1/" -e "s/vuFontSymb/vuFontSymb/g"
//                    ^-[ space TAB ]  [ pipe specific prefix]--^
// Sorry about the C++ style comments this generates.
// ----------------------------------------------------------------------

// Enums
#ifndef vuEnumLightNaLight
// Warning these must be reconciled with the C enums.
// Check auto-generated file "baequate.i"

#define vuEnumLightNaLight 0      // rpNALIGHTTYPE
#define vuEnumLightDirectional 1  // rpLIGHTDIRECTIONAL
#define vuEnumLightAmbient 2      // rpLIGHTAMBIENT
#define vuEnumLightPoint 128      // rpLIGHTPOINT
#define vuEnumLightSpot 129       // rpLIGHTSPOT
#define vuEnumLightSpotSoft 130   // rpLIGHTSPOTSOFT

#endif

// Data in high memory

#ifndef vuSDmat0

#define vuSDBlockLow 0x3c3
#define vuSDBlockHigh 0x3f0

#define vuSDmat0 vuSDBlockHigh
#define vuSDmat1 vuSDBlockHigh+1
#define vuSDmat2 vuSDBlockHigh+2
#define vuSDmat3 vuSDBlockHigh+3
#define vuSDnearClip vuSDBlockHigh+4
#define vuSDfarClip vuSDBlockHigh+5
#define vuSDxMaxyMax vuSDBlockHigh+6
#define vuSDcamWcamHzScale vuSDBlockHigh+7
#define vuSDoffXoffYzShift vuSDBlockHigh+8
#define vuSDrealOffset vuSDBlockHigh+9
#define vuSDgifTag vuSDBlockHigh+10
#define vuSDcolScale vuSDBlockHigh+11
#define vuSDsurfProps vuSDBlockHigh+12
#define vuSDpingPongAddr vuSDBlockHigh+13	// x = Out0 address,
                                        // y = Out1 address,
					// z = In address
#define vuSDpingPongCount vuSDBlockHigh+14	// x = Out vert count,
                                        // y = Out prim count,
					// z = In vert count,w = In prim count

#define vuSDLightOffset 0x3d0

#endif

// ----------------------------------------------------------------------
// Put your Pipe specific static data here
// Names should probably be in the "vuFontSymb" name space

#define vuFontSymbStaticData (vuSDBlockLow - 1)

// ----------------------------------------------------------------------
// You must set these correctly for the amount of data above and the size
// of the vertex data. vuFontSymbStrideOfInputCluster will generally be the same
// as the number of clusters that you RpFXBridgeNodeRequestCluster() from
// nodePS2MatBridgeCSL. vuFontSymbStrideOfOutputCluster will generally be the NREG
// value in the gif tag if the output cluster is dispatched to GS

#define vuFontSymbStrideOfInputCluster 2
#define vuFontSymbStrideOfOutputCluster 3

// Set the base of the high memory data here
#define vuFontSymbStaticDataStart (vuFontSymbStaticData - 6)

// ----------------------------------------------------------------------
// It should be unnecessary to change any of the defines below this line.

// The following is calculated giving the VIF Offset for UNPACK double buffering
#define vuFontSymbVIFOffset (vuFontSymbStaticDataStart/2)

// The following are offsets for tristrips. They allow enough space that the
// incomming tristrip can be broken in half and dispatched as two parts.
// This makes multipass easier

// vuFontSymbTSVertexCount is a slight under estimate due to rounding
#define vuFontSymbTSVertexCount ((vuFontSymbVIFOffset-2-3*vuFontSymbStrideOfOutputCluster)/(vuFontSymbStrideOfInputCluster+vuFontSymbStrideOfOutputCluster))
#define vuFontSymbTSOutGif (vuFontSymbTSVertexCount*vuFontSymbStrideOfInputCluster)
#define vuFontSymbTSOutBuf (vuFontSymbTSOutGif+1)
#define vuFontSymbTSOutGif2 (vuFontSymbTSOutBuf+((vuFontSymbTSVertexCount+3)/2)*vuFontSymbStrideOfOutputCluster)
#define vuFontSymbTSOutBuf2 (vuFontSymbTSOutGif2+1)
#define vuFontSymbTSOutHBVC ((vuFontSymbTSVertexCount+3)/2)
#define vuFontSymbTSOutHBTC (vuFontSymbTSOutHBVC-2)

// The following are offsets for trilists. They allow enough space that the
// incomming trilist can be dispatched at 1 giftag per triangle! This allows
// for a special case (True clipping)

// vuFontSymbTLTriCount is a slight under estimate due to rounding
#define vuFontSymbTLTriCount ((vuFontSymbVIFOffset-(3*vuFontSymbStrideOfOutputCluster+1))/(3*(vuFontSymbStrideOfInputCluster+vuFontSymbStrideOfOutputCluster)+1))
#define vuFontSymbTLOutGif (vuFontSymbTLTriCount*3*vuFontSymbStrideOfInputCluster)
#define vuFontSymbTLOutBuf (vuFontSymbTLOutGif+1)
// vuFontSymbTLOutGif2 depends on vuFontSymbTLOutGif, not vuFontSymbTLOutBuf
#define vuFontSymbTLOutGif2 (vuFontSymbTLOutGif+((vuFontSymbTLTriCount+1)/2)*(3*vuFontSymbStrideOfOutputCluster+1))
#define vuFontSymbTLOutBuf2 (vuFontSymbTLOutGif2+1)
#define vuFontSymbTLOutHBTC ((vuFontSymbTLTriCount+1)/2)
#define vuFontSymbTLOutHBVC (vuFontSymbTLOutHBTC*3)
// ----------------------------------------------------------------------
