
/***************************************************************************
 *                                                                         *
 * Module  : path.h                                                        *
 *                                                                         *
 * Purpose :                                                               *
 *                                                                         *
 **************************************************************************/

#ifndef PATH_H
#define PATH_H

/****************************************************************************
 Includes
 */
#include <rwcore.h>
/* #include <rpworld.h> */

/****************************************************************************
 Defines
 */

/****************************************************************************
 Global Types
 */
enum rt2dLinetype
{
    rt2dMOVE = 0,
    rt2dLINE = 1,
    rt2dCURVE = 2,
    rt2DLINETYPEFORCEENUMSIZEINT = RWFORCEENUMSIZEINT
};
typedef enum rt2dLinetype rt2dLinetype;

typedef struct rt2dPathNode rt2dPathNode;
struct rt2dPathNode
{
    rt2dLinetype        type;
    RwV2d               pos, normal;
    RwReal              dist;
};

#include "rt2d.h"

struct Rt2dPath
{
    RwSList            *segments;
    RwBool              closed;
    RwBool              flat;
    RwReal              inset;
    Rt2dPath           *next;
    Rt2dPath           *curr;
};

/****************************************************************************
 Function prototypes
 */
extern Rt2dPath    *_rt2dScratchPath(void);
extern Rt2dPath    *_rt2dSubPathFlatten(Rt2dPath * flatpath,
                                        const Rt2dPath * path);
extern Rt2dBBox    *_rt2dFlatSubPathExtendBBox(const Rt2dPath * path,
                                               Rt2dBBox * bbox);
extern Rt2dPath    *_rt2dPathOptimize(Rt2dPath * path);

extern void         _rt2dPathClose(void);
extern RwBool       _rt2dPathOpen(void);

#endif /* PATH_H */
