#ifndef RPSKINXBOXPLAIN_H
#define RPSKINXBOXPLAIN_H

#include <xtl.h>
#include <d3d8.h>

#include <rwcore.h>
#include <rpworld.h>

#include "rpplugin.h"
#include "rpdbgerr.h"

extern void _rwXbRenderStateTexture(RwTexture *texture);

/*
Plain material is shared with skinning & matfx, make them inline so we
don't incur extra function call overhead.
*/
__inline RwInt32 _rpSkinXboxPlainMaterialSetUp( RpMaterial *material, RwInt32 pass )
{
    RWFUNCTION(RWSTRING("_rpSkinXboxPlainMaterialSetUp"));
    RWASSERT( pass == 1 );
    
    RwXboxSetCurrentPixelShader(0);

    if (material->texture)
    {
        /* Color */
        D3DDevice_SetTextureStageState(0, D3DTSS_COLOROP,   D3DTOP_MODULATE);
        D3DDevice_SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_DIFFUSE);
        D3DDevice_SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_TEXTURE);

        /* Alpha */
        D3DDevice_SetTextureStageState(0, D3DTSS_ALPHAOP,   D3DTOP_MODULATE);
        D3DDevice_SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_DIFFUSE);
        D3DDevice_SetTextureStageState(0, D3DTSS_ALPHAARG2, D3DTA_TEXTURE);
        
        _rwXbRenderStateTexture(material->texture);
    }
    else
    {
        /* Color */
        D3DDevice_SetTextureStageState(0, D3DTSS_COLOROP,   D3DTOP_SELECTARG1);
        D3DDevice_SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_DIFFUSE);

        /* Alpha */
        D3DDevice_SetTextureStageState(0, D3DTSS_ALPHAOP,   D3DTOP_SELECTARG1);
        D3DDevice_SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_DIFFUSE);

        _rwXbRenderStateTexture(NULL);
    }
    
    /* no more passes ! */
    RWRETURN( 0 );
}

__inline void _rpSkinXboxPlainMaterialTearDown( RpMaterial *material )
{

}

#endif
