; ----------------------------------------------------------------------
; Warning: This file will be processed using a rather simple sed script
; to turn it into a C include file.
;
; sed -e "s/\([^;]*\);/\1\/\//"					\
;     -e "s/^\.if/#if/" -e "s/^\.else/#else/" -e "s/^\.endif/#endif/"	\
;     -e "s/^\.equ\([ 	][^,]*\),/#define\1/" -e "s/vuSymb/pipeASymb/g"
;                    ^-[ space TAB ]  [ pipe specific prefix]--^
; Sorry about the C++ style comments this generates.
; ----------------------------------------------------------------------

; Enums
.ifndef vuEnumLightNaLight
; Warning these must be reconciled with the C enums.
; Check auto-generated file "baequate.i"

.equ vuEnumLightNaLight, 0      ; rpNALIGHTTYPE
.equ vuEnumLightDirectional, 1  ; rpLIGHTDIRECTIONAL
.equ vuEnumLightAmbient, 2      ; rpLIGHTAMBIENT
.equ vuEnumLightPoint, 128      ; rpLIGHTPOINT
.equ vuEnumLightSpot, 129       ; rpLIGHTSPOT
.equ vuEnumLightSpotSoft, 130   ; rpLIGHTSPOTSOFT

.endif

.equ vuPSFlagsPoint,     0x0;
.equ vuPSFlagsSprite,    0x1;
.equ vuPSFlagsLine,      0x2;

; Data in high memory

.ifndef vuSDmat0

.equ vuSDBlockLow, 0x3e3
.equ vuSDBlockHigh, 0x3f0

.equ vuSDmat0, vuSDBlockHigh
.equ vuSDmat1, vuSDBlockHigh+1
.equ vuSDmat2, vuSDBlockHigh+2
.equ vuSDmat3, vuSDBlockHigh+3
.equ vuSDnearClip, vuSDBlockHigh+4
.equ vuSDfarClip, vuSDBlockHigh+5
.equ vuSDxMaxyMax, vuSDBlockHigh+6
.equ vuSDcamWcamHzScale, vuSDBlockHigh+7
.equ vuSDoffXoffYzShift, vuSDBlockHigh+8
.equ vuSDrealOffset, vuSDBlockHigh+9
.equ vuSDgifTag, vuSDBlockHigh+10
.equ vuSDcolScale, vuSDBlockHigh+11
.equ vuSDsurfProps, vuSDBlockHigh+12
.equ vuSDpingPongAddr, vuSDBlockHigh+13	  ; x = Out0 address,   y = Out1 address,   z = In address
.equ vuSDpingPongCount, vuSDBlockHigh+14  ; x = Out vert count, y = Out prim count, z = In vert count, w = In prim count

; No lighting in the sprite renderer, but we leave the clip buffer in because I'll probably be writing a clipping
; version of this code, so I'll leave it there.

.endif

.equ vuSDLightOffset, 0x3c3

; ----------------------------------------------------------------------
; Put your Pipe specific static data here
; Names should probably be in the "vuSymb" name space

.equ vuSymbEmitter1,		 (vuSDLightOffset-1)	    ; width, height, friction, duration
.equ vuSymbEmitter2,		 (vuSymbEmitter1-1)			; randomseed, speed, speedvariation, angle (pre-tan'd),
.equ vuSymbEmitter3,		 (vuSymbEmitter2-1)			; ForceX, ForceY, ForceZ, control flags
.equ vuSymbSpriteColourA,    (vuSymbEmitter3-1)         ; RGBA
.equ vuSymbSpriteColourB,    (vuSymbSpriteColourA-1)    ; RGBA
.equ vuSymbSpriteScale,      (vuSymbSpriteColourB-1)    ; width, height, growth, numparticles
.equ vuSymbSpriteTime,       (vuSymbSpriteScale-1)      ; time, flighttime, spare, 1/flighttime
.equ vuSymbCustomGIF,        (vuSymbSpriteTime-1)


; ----------------------------------------------------------------------
; You must set these correctly for the amount of data above and the size
; of the vertex data. vuSymbStrideOfInputCluster will generally be the same
; as the number of clusters that you RpFXBridgeNodeRequestCluster() from
; nodePS2MatBridgeCSL. vuSymbStrideOfOutputCluster will generally be the NREG
; value in the gif tag if the output cluster is dispatched to GS

.equ vuSymbStrideOfInputCluster,  4
.equ vuSymbStrideOfOutputCluster, 6

; Set the base of the high memory data here
.equ vuSymbStaticDataStart, vuSymbCustomGIF

;---------------------------------------------------------------------------------------------------------------------

; Define the size of the batches
.equ vertSize,              (vuSymbStrideOfInputCluster)
.equ vertexSize,            (vuSymbStrideOfInputCluster)

.equ    inPos,              (0)
.equ    inVel,				(1)
.equ    inScale,            (2)
.equ    inRGBA,				(3)


.equ outputPointVertSize,	2				;No Texture/UV support for points yet
.equ outputLineVertSize,	6				;2* XYZ + RGBA + STQ
.equ outputSpriteVertSize,	5				;2* XYZ + RGBA + STQ

.equ countPointVerts,		((vuSymbStaticDataStart)/(vuSymbStrideOfInputCluster + (2*outputPointVertSize)))
.equ countLineVerts,		((vuSymbStaticDataStart)/(vuSymbStrideOfInputCluster + (2*outputLineVertSize)))
.equ countSpriteVerts,		((vuSymbStaticDataStart)/(vuSymbStrideOfInputCluster + (2*outputSpriteVertSize)))


.equ outputLineGif1,		((countLineVerts * vuSymbStrideOfInputCluster)+1)
.equ outputLineBuf1,		(outputLineGif1+1)
.equ outputLineGif2,		(outputLineBuf1+((countLineVerts*outputLineVertSize)+1))
.equ outputLineBuf2,		(outputLineGif2+1)

.equ outputSpriteGif1,		((countSpriteVerts * vuSymbStrideOfInputCluster)+1)
.equ outputSpriteBuf1,      (outputSpriteGif1+1)
.equ outputSpriteGif2,		(outputSpriteBuf1+((countSpriteVerts*outputSpriteVertSize)+1))
.equ outputSpriteBuf2,		(outputSpriteGif2+1)


; We don't use anything after here
; ----------------------------------------------------------------------
; It should be unnecessary to change any of the defines below this line.

; The following is calculated giving the VIF Offset for UNPACK double buffering
.equ vuSymbVIFOffset, (vuSymbStaticDataStart/2)

; The following are offsets for tristrips. They allow enough space that the
; incomming tristrip can be broken in half and dispatched as two parts.
; This makes multipass easier

; vuSymbTSVertexCount is a slight under estimate due to rounding
.equ vuSymbTSVertexCount, ((vuSymbVIFOffset)/(vuSymbStrideOfInputCluster+vuSymbStrideOfOutputCluster))
.equ vuSymbTSOutGif,      ((vuSymbTSVertexCount*vuSymbStrideOfInputCluster)+1)
.equ vuSymbTSOutBuf,      (vuSymbTSOutGif+1)
.equ vuSymbTSOutGif2,     (vuSymbTSOutBuf+((vuSymbTSVertexCount*vuSymbStrideOfInputCluster)+1))
.equ vuSymbTSOutBuf2,     (vuSymbTSOutGif2+1)

; The following are offsets for trilists. They allow enough space that the
; incomming trilist can be dispatched at 1 giftag per triangle! This allows
; for a special case (True clipping)

; vuSymbTLTriCount is a slight under estimate due to rounding
.equ vuSymbTLTriCount,  (4)
; ----------------------------------------------------------------------
