// ----------------------------------------------------------------------
// Warning: This file will be processed using a rather simple sed script
// to turn it into a C include file.
//
// sed -e "s/\([^;]*\);/\1\/\//"					\
//     -e "s/^\.if/#if/" -e "s/^\.else/#else/" -e "s/^\.endif/#endif/"	\
//     -e "s/^\.equ\([ 	][^,]*\),/#define\1/" -e "s/pipeASymb/pipeASymb/g"
//                    ^-[ space TAB ]  [ pipe specific prefix]--^
// Sorry about the C++ style comments this generates.
// ----------------------------------------------------------------------

// Enums
#ifndef vuEnumLightNaLight
// Warning these must be reconciled with the C enums.
// Check auto-generated file "baequate.i"

#define vuEnumLightNaLight 0      // rpNALIGHTTYPE
#define vuEnumLightDirectional 1  // rpLIGHTDIRECTIONAL
#define vuEnumLightAmbient 2      // rpLIGHTAMBIENT
#define vuEnumLightPoint 128      // rpLIGHTPOINT
#define vuEnumLightSpot 129       // rpLIGHTSPOT
#define vuEnumLightSpotSoft 130   // rpLIGHTSPOTSOFT

#endif

#define vuPSFlagsPoint     0x0//
#define vuPSFlagsSprite    0x1//
#define vuPSFlagsLine      0x2//

// Data in high memory

#ifndef vuSDmat0

#define vuSDBlockLow 0x3e3
#define vuSDBlockHigh 0x3f0

#define vuSDmat0 vuSDBlockHigh
#define vuSDmat1 vuSDBlockHigh+1
#define vuSDmat2 vuSDBlockHigh+2
#define vuSDmat3 vuSDBlockHigh+3
#define vuSDnearClip vuSDBlockHigh+4
#define vuSDfarClip vuSDBlockHigh+5
#define vuSDxMaxyMax vuSDBlockHigh+6
#define vuSDcamWcamHzScale vuSDBlockHigh+7
#define vuSDoffXoffYzShift vuSDBlockHigh+8
#define vuSDrealOffset vuSDBlockHigh+9
#define vuSDgifTag vuSDBlockHigh+10
#define vuSDcolScale vuSDBlockHigh+11
#define vuSDsurfProps vuSDBlockHigh+12
#define vuSDpingPongAddr vuSDBlockHigh+13	  // x = Out0 address,   y = Out1 address,   z = In address
#define vuSDpingPongCount vuSDBlockHigh+14  // x = Out vert count, y = Out prim count, z = In vert count, w = In prim count

// No lighting in the sprite renderer, but we leave the clip buffer in because I'll probably be writing a clipping
// version of this code, so I'll leave it there.

#endif

#define vuSDLightOffset 0x3c3

// ----------------------------------------------------------------------
// Put your Pipe specific static data here
// Names should probably be in the "pipeASymb" name space

#define pipeASymbEmitter1		 (vuSDLightOffset-1)	    // width, height, friction, duration
#define pipeASymbEmitter2		 (pipeASymbEmitter1-1)			// randomseed, speed, speedvariation, angle (pre-tan'd),
#define pipeASymbEmitter3		 (pipeASymbEmitter2-1)			// ForceX, ForceY, ForceZ, control flags
#define pipeASymbSpriteColourA    (pipeASymbEmitter3-1)         // RGBA
#define pipeASymbSpriteColourB    (pipeASymbSpriteColourA-1)    // RGBA
#define pipeASymbSpriteScale      (pipeASymbSpriteColourB-1)    // width, height, growth, numparticles
#define pipeASymbSpriteTime       (pipeASymbSpriteScale-1)      // time, flighttime, spare, 1/flighttime
#define pipeASymbCustomGIF        (pipeASymbSpriteTime-1)


// ----------------------------------------------------------------------
// You must set these correctly for the amount of data above and the size
// of the vertex data. pipeASymbStrideOfInputCluster will generally be the same
// as the number of clusters that you RpFXBridgeNodeRequestCluster() from
// nodePS2MatBridgeCSL. pipeASymbStrideOfOutputCluster will generally be the NREG
// value in the gif tag if the output cluster is dispatched to GS

#define pipeASymbStrideOfInputCluster  4
#define pipeASymbStrideOfOutputCluster 6

// Set the base of the high memory data here
#define pipeASymbStaticDataStart pipeASymbCustomGIF

//---------------------------------------------------------------------------------------------------------------------

// Define the size of the batches
#define vertSize              (pipeASymbStrideOfInputCluster)
#define vertexSize            (pipeASymbStrideOfInputCluster)

#define    inPos              (0)
#define    inVel				(1)
#define    inScale            (2)
#define    inRGBA				(3)


#define outputPointVertSize	2				//No Texture/UV support for points yet
#define outputLineVertSize	6				//2* XYZ + RGBA + STQ
#define outputSpriteVertSize	5				//2* XYZ + RGBA + STQ

#define countPointVerts		((pipeASymbStaticDataStart)/(pipeASymbStrideOfInputCluster + (2*outputPointVertSize)))
#define countLineVerts		((pipeASymbStaticDataStart)/(pipeASymbStrideOfInputCluster + (2*outputLineVertSize)))
#define countSpriteVerts		((pipeASymbStaticDataStart)/(pipeASymbStrideOfInputCluster + (2*outputSpriteVertSize)))


#define outputLineGif1		((countLineVerts * pipeASymbStrideOfInputCluster)+1)
#define outputLineBuf1		(outputLineGif1+1)
#define outputLineGif2		(outputLineBuf1+((countLineVerts*outputLineVertSize)+1))
#define outputLineBuf2		(outputLineGif2+1)

#define outputSpriteGif1		((countSpriteVerts * pipeASymbStrideOfInputCluster)+1)
#define outputSpriteBuf1      (outputSpriteGif1+1)
#define outputSpriteGif2		(outputSpriteBuf1+((countSpriteVerts*outputSpriteVertSize)+1))
#define outputSpriteBuf2		(outputSpriteGif2+1)


// We don't use anything after here
// ----------------------------------------------------------------------
// It should be unnecessary to change any of the defines below this line.

// The following is calculated giving the VIF Offset for UNPACK double buffering
#define pipeASymbVIFOffset (pipeASymbStaticDataStart/2)

// The following are offsets for tristrips. They allow enough space that the
// incomming tristrip can be broken in half and dispatched as two parts.
// This makes multipass easier

// pipeASymbTSVertexCount is a slight under estimate due to rounding
#define pipeASymbTSVertexCount ((pipeASymbVIFOffset)/(pipeASymbStrideOfInputCluster+pipeASymbStrideOfOutputCluster))
#define pipeASymbTSOutGif      ((pipeASymbTSVertexCount*pipeASymbStrideOfInputCluster)+1)
#define pipeASymbTSOutBuf      (pipeASymbTSOutGif+1)
#define pipeASymbTSOutGif2     (pipeASymbTSOutBuf+((pipeASymbTSVertexCount*pipeASymbStrideOfInputCluster)+1))
#define pipeASymbTSOutBuf2     (pipeASymbTSOutGif2+1)

// The following are offsets for trilists. They allow enough space that the
// incomming trilist can be dispatched at 1 giftag per triangle! This allows
// for a special case (True clipping)

// pipeASymbTLTriCount is a slight under estimate due to rounding
#define pipeASymbTLTriCount  (4)
// ----------------------------------------------------------------------
