/*===========================================================================*
 *--- Include files ---------------------------------------------------------*
 *===========================================================================*/
#include <rwcore.h>
#include <rpworld.h>

#include "rpplugin.h"
#include "rpdbgerr.h"

#include "nodexboxpatchatomicinstance.h"

#include "patchxboxplain.h"

/*===========================================================================*
 *--- Private Types ---------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Private Global Variables ----------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Private Defines -------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Local Types -----------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Local Global Variables ------------------------------------------------*
 *===========================================================================*/
#if (!defined(DXOYGEN))
static const char rcsid[] __RWUNUSED__ =
    "@@@@(#)$Id: patchxboxplain.c,v 1.1 2001/10/03 15:11:41 davidg Exp $";
#endif /* (!defined(DXOYGEN)) */

/*****************************************************************************
 _rwXBoxPatchPipelineNodeInitFn

 Initializes the private data (refinement ON by default)

 Inputs :
 Outputs :
 */
RwBool
_rwXBoxPatchPipelineNodeInitFn( RxPipelineNode *self )
{
    RWFUNCTION(RWSTRING("_rwXBoxPatchPipelineNodeInitFn"));

    if (self)
    {
        RpNodePatchData *data = ((RpNodePatchData *) self->privateData);

        RxNodeDefinition    *instanceDefaultNode;
        RxPipelineNode      *defaultNode;

        data->patchOn = TRUE;
        data->numExtraUVs = 0;
        data->numExtraRGBAs = 0;

        /*
         * Find default render callback
         */
        /* Get the instance node definition */
        instanceDefaultNode = RxNodeDefinitionGetXBoxAtomicAllInOne();
        RWASSERT(NULL != instanceDefaultNode);

        defaultNode = RxPipelineFindNodeByName(RpAtomicGetDefaultInstancePipeline(),
                                                instanceDefaultNode->name, NULL, NULL);

        if (defaultNode != NULL)
        {
            data->renderCallback = RxXBoxAllInOneGetRenderCallBack(defaultNode);
        }
        else
        {
            data->renderCallback = NULL;
        }

        RWRETURN(TRUE);
    }

    RWRETURN(FALSE);
}
