/*===========================================================================*
 *--- Include files ---------------------------------------------------------*
 *===========================================================================*/
#include <rwcore.h>
#include <rpworld.h>

#include "rpplugin.h"
#include "rpdbgerr.h"

#include "rppatch.h"

#include "patch.h"

#include "nodeOpenGLpatchatomicinstance.h"

/*===========================================================================*
 *--- Private Types ---------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Private Global Variables ----------------------------------------------*
 *===========================================================================*/
PatchGlobals _rpPatchGlobals =
{
    0,                     /* RwInt32        engineOffset      */
    0,                     /* RwInt32        atomicOffset      */
    0,                     /* RwInt32        geometryOffset    */
    { 0, 0 },              /* RwModuleInfo   module            */
    (RwFreeList *)NULL,    /* RwFreeList    *atomicFreeList    */
    (RwFreeList *)NULL,    /* RwFreeList    *geometryFreeList  */
    {                      /* PatchPlatform  platform          */
        (RxPipeline *)NULL /* RxPipeline    *pipeline          */
    }
};

/*===========================================================================*
 *--- Private Defines -------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Local Types -----------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Local Global Variables ------------------------------------------------*
 *===========================================================================*/
#if (!defined(DXOYGEN))
static const char rcsid[] __RWUNUSED__ =
    "@@@@(#)$Id: patchopengl.c,v 1.6 2001/10/04 12:04:17 davidg Exp $";
#endif /* (!defined(DXOYGEN)) */

/*===========================================================================*
 *--- Local Defines ---------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Local functions -------------------------------------------------------*
 *===========================================================================*/

/*****************************************************************************
 PatchPipelineCreate

 TODO

 Inputs :
 Outputs :
 */
static RxPipeline *
PatchPipelineCreate(void)
{
    RxPipeline *pipe;
    RxLockedPipe *lpipe;
    RxPipelineNode *node;

    RWFUNCTION(RWSTRING("PatchPipelineCreate"));

    pipe = RxPipelineCreate();
    RWASSERT(NULL != pipe);

    pipe->pluginId = rwID_PATCHPLUGIN;

    lpipe = RxPipelineLock(pipe);
    RWASSERT(NULL != lpipe);

    lpipe = RxLockedPipeAddFragment(
                lpipe, NULL,
                RxNodeDefinitionGetOpenGLPatchAtomicInstance(),
                RxNodeDefinitionGetAtomicEnumerateLights(),
                RxNodeDefinitionGetMaterialScatter(),
                NULL );
    RWASSERT(NULL != lpipe);

    /* Make sure indices and OpenGL specific data clusters propagate to
     * the end of the pipeline, such that they can be passed to the subsequent
     * render pipelines.
     */
    node = RxPipelineFindNodeByName(lpipe, RxNodeDefinitionGetMaterialScatter()->name,
                                            NULL,  NULL);
    RWASSERT(NULL != node);
    RxPipelineNodeRequestCluster(lpipe, node, &RxClIndices);
    RxPipelineNodeRequestCluster(lpipe, node, &RxClOpenGLExtensionData);
    RxPipelineNodeRequestCluster(lpipe, node, &RxClUVs);

    lpipe = RxLockedPipeUnlock(lpipe);
    RWASSERT(NULL != lpipe);

    RWRETURN(pipe);
}

/*===========================================================================*
 *--- Private functions -----------------------------------------------------*
 *===========================================================================*/

/****************************************************************************
 _rpSkinPipelinesCreate

 Create the patch pipelines.

 Inputs :   pipes - RwUInt32 bit-field defining which pipes to create
                        rpPATCHPIPELINEGENERIC = 0x01,
                        rpPATCHPIPELINESKINNED = 0x02,
                        rpPATCHPIPELINEMATFX   = 0x04,
 Outputs:   RwBool - on success.
 */
RwBool
_rpPatchPipelinesCreate(RwUInt32 pipes __RWUNUSED__)
{
    RWFUNCTION(RWSTRING("_rpPatchPipelinesCreate"));

    _rpPatchGlobals.platform.pipeline = PatchPipelineCreate();
    RWASSERT(NULL != _rpPatchGlobals.platform.pipeline);

    RWRETURN(TRUE);
}

/****************************************************************************
 _rpPatchPipelinesDestroy

 Destroy the patch pipelines.

 Inputs :   None
 Outputs:   RwBool - on success.
 */
RwBool
_rpPatchPipelinesDestroy(void)
{
    RWFUNCTION(RWSTRING("_rpPatchPipelinesDestroy"));

    if(NULL != _rpPatchGlobals.platform.pipeline)
    {
        RxPipelineDestroy(_rpPatchGlobals.platform.pipeline);
        _rpPatchGlobals.platform.pipeline = (RxPipeline *)NULL;
    }

    RWRETURN(TRUE);
}

/****************************************************************************
 _rpPatchPipelinesAttach

 Attach the correct patch pipeline to the atomic.

 Inputs :   atomic *   - Pointer to the atomic.
 Outputs:   RpAtomic * - Pointer to the atomic on success.
 */
RpAtomic *
_rpPatchPipelinesAttach(RpAtomic *atomic)
{
    RxPipeline *pipeline;

    RWFUNCTION(RWSTRING("_rpPatchPipelinesAttach"));
    RWASSERT(NULL != atomic);

    pipeline = _rpPatchGlobals.platform.pipeline;
    RWASSERT(NULL != pipeline);

    atomic = RpAtomicSetPipeline(atomic, pipeline);
    RWASSERT(NULL != atomic);

    RWRETURN(atomic);
}

/*===========================================================================*
 *--- Plugin Engine Functions -----------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Plugin API Functions --------------------------------------------------*
 *===========================================================================*/
