#ifndef _NODED3D7PATCHATOMICINSTANCE_H
#define _NODED3D7PATCHATOMICINSTANCE_H
/*===========================================================================*
 *--- Include files ---------------------------------------------------------*
 *===========================================================================*/

#include <d3d.h>

#include <rwcore.h>
#include <rpworld.h>

#include "rppatch.h"

#include "patchexpander.h"

/*===========================================================================*
 *--- Private Defines -------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Private Types ---------------------------------------------------------*
 *===========================================================================*/

/*
 * The refinement node generates new vertices and so has to interpolate
 * per-vertex attributes from the original set of vertices to generate
 * values for the generated vertices. It can (barycentrically)
 * interpolate any number of additional 'passes' of UVs or RGBAs,
 * provided that:
 * (a) these extra clusters are added by the app at pipeline construction
 *     time through the use of RxPipelineNodeRequestCluster(),
 * (b) the extra UVs/RGBAs are the last clusters added to the node, and
 * (c) all the UVs come before the RGBAs (and there are no other cluster
 *     types sprinkled in amongst the UVs/RGBAs)
 */
struct RpNodePatchData
{
    RwBool  patchOn;       /* patchOn       */
    RwInt32 numExtraUVs;   /* numExtraUVs   */
    RwInt32 numExtraRGBAs; /* numExtraRGBAs */
};
typedef struct RpNodePatchData RpNodePatchData;

typedef struct RpPatchDX7Atomic RpPatchDX7Atomic;
struct RpPatchDX7Atomic
{
    RwBool optimized;                     /* Vertex buffer should be
                                           * optimized?                     */
    LPDIRECT3DVERTEXBUFFER7 vertexBuffer; /* Vertex buffer                  */
    RpPatchInstanceAtomic instAtomic;     /* Must be last field because of
                                           * the meshes are after this.     */
};

/*===========================================================================*
 *--- Private Global Variables ----------------------------------------------*
 *===========================================================================*/
extern LPDIRECT3D7  lpD3D7;

/* Device capabilities for currently selected d3d device */
extern D3DDEVICEDESC7 d3dGHardwareCaps;

/*===========================================================================*
 *--- Private Functions -----------------------------------------------------*
 *===========================================================================*/
#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */

extern RxNodeDefinition *
RxNodeDefinitionGetDX7PatchAtomicInstance(void);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _NODED3D7PATCHATOMICINSTANCE_H */
