#ifndef PATCHSMOOTH_H
#define PATCHSMOOTH_H

/*===========================================================================*
 *--- Include files ---------------------------------------------------------*
 *===========================================================================*/
#include <rwcore.h>
#include <rpworld.h>

#include "rpdbgerr.h"
#include "rppatch.h"

#include "patchmesh.h"

/*===========================================================================*
 *--- Private Defines -------------------------------------------------------*
 *===========================================================================*/
#define PATCHSMOOTHVERTPOSTOL ((RwReal)(1.0e-4))
#define PATCHSMOOTHVERTNRMTOL ((RwReal)(0.5))

/*===========================================================================*
 *--- Private Types ---------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Private Global Variables ----------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Private functions -----------------------------------------------------*
 *===========================================================================*/
#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */

extern PatchMesh *
_rpPatchSmoothNormal( PatchMesh *patchMesh,
                      RwReal vertPosTol,
                      RwReal vertNrmTol,
                      RwV3d *sourceNormals,
                      RwV3d *targetNormals );


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* PATCHSMOOTH_H */
