#ifndef _PATCHEXPANDER_H
#define _PATCHEXPANDER_H

/*===========================================================================*
 *--- Include files ---------------------------------------------------------*
 *===========================================================================*/
#include <rwcore.h>
#include <rpworld.h>

#include "rppatch.h"

/*===========================================================================*
 *--- Private Defines -------------------------------------------------------*
 *===========================================================================*/
#define rpPATCHNUMCONTROLINDICES rpQUADPATCHNUMCONTROLINDICES

/*===========================================================================*
 *--- Private Types ---------------------------------------------------------*
 *===========================================================================*/
typedef struct RpPatchInstanceMesh RpPatchInstanceMesh;
struct RpPatchInstanceMesh
{
    RxVertexIndex *indices;
    RwUInt32       numIndices;
    RwUInt32       minVert;
    RwUInt32       numVerts;
    RpMaterial    *material;
    RpMesh        *mesh;
};

typedef struct RpPatchInstanceAtomic RpPatchInstanceAtomic;
struct RpPatchInstanceAtomic
{
    RwUInt32 serialNum; /* Serial # - combination of elements contributing to
                         * instanced data.  Enables us to detect when a
                         * re-instance is necessary.
                         */
    RxVertexIndex *indices; /* Vertex index buffer. */
    RxObjSpace3DVertex *vertices; /* We also keep the vertices around for
                                   * generic nodes and software lighting
                                   * to play around with.
                                   */
    RwInt32 numMeshes;    /* The number of meshes.        */
    RwInt32 totalIndices; /* The total number of indices. */
    RwInt32 totalVerts;   /* The total number of verts.   */
    RwInt32 res;          /* Resolution of the facetting. */
    RpPatchInstanceMesh meshes[1]; /* The meshes. */
};

/*===========================================================================*
 *--- Private Global Variables ----------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Private Functions -----------------------------------------------------*
 *===========================================================================*/
#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */

extern RwBool
_rpPatchInstanceAtomic( RpPatchInstanceAtomic *instAtomic,
                        RpAtomic *atomic,
                        RwInt32 res );

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _PATCHEXPANDER_H */
