/*----------------------------------------------------------------------*/
/*-                             Includes                               -*/
/*----------------------------------------------------------------------*/
#include <rpdbgerr.h>
#include <rpmatfx.h>

#include "../../driver/sky2/baasm.h"

#include "rpplugin.h"
#include "effectPipes.h"
#include "effectPipesSky.h"

#include "SKY2_BumpEnvMap/bumpEnvPipe.h"
#include "SKY2_BumpEnvMap/stddata.h"

/*----------------------------------------------------------------------*/
/*-                                Definition                          -*/
/*----------------------------------------------------------------------*/
matFXVUcode RWALIGN(skyBumpEnvMapTransforms, rpMATFXALIGNMENT) = 
{
    &BumpEnvMapPRS, &vu1nullTrans, 
    &BumpEnvMapPRL, &vu1nullTrans,
    &vu1nullTrans,  &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans,  &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans,  &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans,  &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans,  &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans,  &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans,  &vu1nullTrans, &vu1nullTrans, &vu1nullTrans
};

/*----------------------------------------------------------------------*/
/*-                                Functions                           -*/
/*----------------------------------------------------------------------*/
RwBool
_rpMatFXBumpEnvMapInstanceCallBack( void **clusterData,
                                    RwUInt32 __RWUNUSED__ numClusters )
{
    /* --------------- Pipe --------------------------------------*/
    RxPS2Mesh                      *mesh = (RxPS2Mesh *)clusterData[0];
    RxPS2DMASessionRecord *dmaSessionRec = (RxPS2DMASessionRecord *)clusterData[1];
    rpMatFXMaterialData    *materialData = 
        (rpMatFXMaterialData *)*MATFXMATERIALGETDATA(mesh->mesh->material);
    /* --------------- Bump env map ------------------------------*/
    RwTexture          *bumpMapTexture = (RwTexture *) NULL;
    RwTexture          *envMapTexture  = (RwTexture *) NULL;    
    RwUInt64            primSwitch     = 0x4l;
    RwUInt64            fogSwitch      = 0x0l;
    RwReal              envMapCoef;
    RwReal              bumpMapCoef;
    RwBool              blendmode;

    RWFUNCTION(RWSTRING("_rpMatFXBumpEnvMapInstanceCallBack"));
    RWASSERT(mesh);
    RWASSERT(materialData);

    bumpMapCoef = materialData->data[rpSECONDPASS].data.bumpMap.coef *
        materialData->data[rpSECONDPASS].data.bumpMap.invBumpWidth;
    bumpMapTexture =
        materialData->data[rpSECONDPASS].data.bumpMap.texture;

    /*-------------- Do we have a bumpMap texture? ------------------*/
    if (NULL == bumpMapTexture)
    {
        bumpMapTexture = mesh->mesh->material->texture;
    }
    
    blendmode  = materialData->data[rpTHIRDPASS].data.envMap.useFrameBufferAlpha;
    envMapCoef = materialData->data[rpTHIRDPASS].data.envMap.coef;
    envMapTexture = materialData->data[rpTHIRDPASS].data.envMap.texture;
    RWASSERT(envMapTexture);

    /*--------------- set the prim type ----------*/
    if (dmaSessionRec->transType & 4)
    {
        /*--- Tri-list Setting 2nd context ---*/
        primSwitch = 0x3l;
    }
    /*--------------- set the fog ----------------*/
    if (dmaSessionRec->transType & 1)
    {
        /*--- 2nd context fog activated ------*/
        fogSwitch = 0x1l;
    }
    {
        RwUInt128           ltmp    = 0;
        RwUInt64            prim    = 0x0l;
        RwUInt64            rastex1 = 0;
        RwUInt64            rastex2 = 0;
        RwUInt32			val1, val2;
        RwUInt64            tmp, tmp1;
        
        if (NULL != bumpMapTexture)
        {
	       _rpMatFXUploadTexture(bumpMapTexture, dmaSessionRec, mesh);
	        skyTexGetTex0(bumpMapTexture->raster, &val1, &val2); 
	        rastex1 = ((RwUInt64) val1 << 32) | val2; 
	    }
	    
        /*------ Upload the second texture ------*/
        if (NULL != envMapTexture)
        {
	        skyTexCacheAccessRaster(envMapTexture->raster, TRUE);
  	        skyTexGetTex0(envMapTexture->raster, &val1, &val2);
    	    rastex2 = ((RwUInt64) val1 << 32) | val2;            
        }

        /*------ DMA data transfer --------------*/
        sweFinaliseOpenLocalPkt((int) (SWE_PKT_DMA_MODE_CHAIN_TTE |
                                       SWE_PKT_LOCAL |
                                       SWE_PKT_VU1 |
                                       SWE_PKT_CIRCALLOC), /**/ -27 /**/);
        if (!sweLocalPacket)
        {
            RWRETURN(FALSE);
        }                                       
        tmp  = ((1l << 28)      | (/**/ 25 /**/));
        tmp1 = ((((0x6cl << 24) | (/**/ 20 /**/ << 16) |
               ((long) (pipeASymbStaticBumpEnvDataStart))) << 32) | 
               ((1l << 24) | (4 << 8) | (4)));
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);

        /*------------------ Emboss Bump Data --------------*/
        tmp  = (*(const RwUInt32 *) &bumpMapCoef);
        tmp1 = (*(const RwUInt32 *) &matFXBumpFarPlane);
        tmp1 = ((tmp1 << 32) | (*(const RwUInt32 *) &matFXBumpScale));
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);

        /*------------------ Bump CTX1 Bump Tag2 ------------*/
        tmp  = /* NLOOP */ 4l
             | /* EOP   */ (1l << 15)
             | /* PRE   */ (0l << 46)
             | /* FLG   */ (0l << 58)
             | /* NREG  */ (1l << 60);
        MAKE128(ltmp, 0xel, tmp);
        SWEADDCONTFAST(ltmp);
        MAKE128(ltmp, GS_ALPHA_1, 0x8000000002l);
        SWEADDCONTFAST(ltmp);
        MAKE128(ltmp, GS_TEST_1,  0x50002l);
        SWEADDCONTFAST(ltmp);
        MAKE128(ltmp, GS_FOGCOL,  skyFogcol);
        SWEADDCONTFAST(ltmp);
        MAKE128(ltmp, GS_TEX0_1,  rastex1);
        SWEADDCONTFAST(ltmp);

        /*------------------ Bump CTX1 Bump Tag1 ------------*/
        tmp  = /* NLOOP */ 2l
             | /* EOP   */ (1l << 15)
             | /* PRE   */ (0l << 46)
             | /* FLG   */ (0l << 58)
             | /* NREG  */ (1l << 60);
        MAKE128(ltmp, 0xel, tmp);
        SWEADDCONTFAST(ltmp);
        MAKE128(ltmp, GS_ALPHA_1, 0x8000000048l);
        SWEADDCONTFAST(ltmp);
        MAKE128(ltmp, GS_TEST_1,  0x50002l);
        SWEADDCONTFAST(ltmp);

        /*------------ Bump Map matrix ----------------------*/
        ltmp = *((u_long128 *) & (matFXBumpMatrix.right));
        SWEADDCONTFAST(ltmp);
        ltmp = *((u_long128 *) & (matFXBumpMatrix.up));
        SWEADDCONTFAST(ltmp);
        ltmp = *((u_long128 *) & (matFXBumpMatrix.at));
        SWEADDCONTFAST(ltmp);

        /*------------------ Dark Fog Tag -------------------*/
        tmp  = /* NLOOP */ 2l
             | /* EOP   */ (1l << 15)
             | /* PRE   */ (0l << 46)
             | /* FLG   */ (0l << 58)
             | /* NREG  */ (1l << 60);
        MAKE128(ltmp, 0xel, tmp);
        SWEADDCONTFAST(ltmp);
        MAKE128(ltmp, GS_FOGCOL, 0x000000l);
        SWEADDCONTFAST(ltmp);
        MAKE128(ltmp, GS_TEX0_2, rastex2);
        SWEADDCONTFAST(ltmp);
 
        /*----------- Context 2 Env Map GifTag --------------*/
        prim = ( /* fix  */ 0x0l << 10        |
                 /* ctxt */ 0x1l << 9         |
                 /* fst  */ 0x0l << 8         |
                 /* aa1  */ 0x0l << 7         |
                 /* abe  */ 0x1l << 6         |
                 /* fge  */ fogSwitch << 5    |
                 /* tme  */ 0x1l << 4         |
                 /* iip  */ 0x1l << 3         |
                 /* prim */ primSwitch << 0);
        tmp  = ( /* regs */ 0x3l << (60 - 32) |
                 /* flg  */ 0x0l << (58 - 32) |
                 /* prim */ prim << (47 - 32) |
                 /* pre  */ 0x1l << (46 - 32)) << 32;
        MAKE128(ltmp, 0x412l, tmp);
        SWEADDCONTFAST(ltmp);

        /*------------ Env Map matrix -----------------------*/
        ltmp = *((u_long128 *) & (matFXEnvMatrix.right));
        SWEADDCONTFAST(ltmp);
        ltmp = *((u_long128 *) & (matFXEnvMatrix.up));
        SWEADDCONTFAST(ltmp);
        tmp  = *(const RwUInt64 *) & (matFXEnvMatrix.at.x);
        tmp1 = *(const RwUInt32 *) & (envMapCoef);
        tmp1 = ((tmp1 << 32) | (*(const RwUInt32 *) & (matFXEnvMatrix.at.z)));
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);

        /*------------ Environment Map Datas ----------------*/
        tmp  = *(const RwUInt64 *) (matFXEnvParams);
        tmp1 = *(const RwUInt64 *) (matFXEnvParams + 2);
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);

        /*------------ Padding ------------------------------*/
        tmp  = VIFCMD_NOP | (VIFCMD_NOP << 32);
        tmp1 = (VIFCMD_NOP) | ((VIFCMD_DIRECT | /**/ 4 /**/) << 32);
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);

        /*------------- Second Context Registers ------------*/
        tmp  = /* NLOOP */ 3l
             | /* EOP   */ (1l << 15)
             | /* PRE   */ (0l << 46)
             | /* FLG   */ (0l << 58)
             | /* NREG  */ (1l << 60);
        MAKE128(ltmp, 0xel, tmp);
        SWEADDCONTFAST(ltmp);
        MAKE128(ltmp, GS_ALPHA_2, 0x8000000048l | (0x20 >> blendmode));
        SWEADDCONTFAST(ltmp);
        MAKE128(ltmp, GS_CLAMP_2, 0x00);
        SWEADDCONTFAST(ltmp);
        MAKE128(ltmp, GS_TEST_2,  0x50002l);
        SWEADDCONTFAST(ltmp);

        /*------- Terminate the DMA with an interrupt -------*/
        MAKE128(ltmp, 0l, (0xfl << 28));
        SWEADDCONTFAST(ltmp);

        /*---------------------------------------------------*/
        sweFinaliseOpenLocalPkt(SWE_LPS_CONT, 0);
    }
    RWRETURN(TRUE);
}
