/*
 *  dmphanim.h - delta morph animation system
 */

#if (!defined(_DMPHANIM_H))
#define _DMPHANIM_H

/*===========================================================================*
 *--- Include files ---------------------------------------------------------*
 *===========================================================================*/

#include "rwcore.h"
#include "rpworld.h"

/*===========================================================================*
 *--- Defines ---------------------------------------------------------------*
 *===========================================================================*/

#define rpDMORPHANIMATIONSTREAMCURRVERSION (0x100)

/*===========================================================================*
 *--- Types -----------------------------------------------------------------*
 *===========================================================================*/

/*--- rpDMorphFrame ---------------------------------------------------------
 *
 *  Animation frame.
 */
typedef struct rpDMorphFrame rpDMorphFrame;
struct rpDMorphFrame
{
    /* Ordering must be maintained here for stream compatibility */

    /*--- Interpolation data ---*/
    RwReal   startValue;
    RwReal   endValue;
    RwReal   duration;
    /*--- Utility data ---*/
    RwReal   recipDuration;
    /*--- Linking ---*/
    RwUInt32 nextFrame;
};


/*--- rpDMorphFrameSequence -------------------------------------------------
 *
 *  A linked sequence of animation frames.
 */
typedef struct rpDMorphFrameSequence rpDMorphFrameSequence;
struct rpDMorphFrameSequence
{
    RwUInt32         numFrames;
    rpDMorphFrame    *frames;

};

/*--- RpDMorphAnimation -----------------------------------------------------
 *
 *  An array of animation sequences, one for each morph target.
 */
struct RpDMorphAnimation
{
    RwUInt32                numDMorphTargets;
    rpDMorphFrameSequence   *frameSequences;
};


/* All functions are API - see rpdmorph.h */

#endif /* _DMPHANIM_H */
