
/****************************************************************************
 *
 * VRML 2.0 to RW3.0 Converter
 * Copyright (C) 1997 Criterion Technologies
 *
 * Author  : Damian Scallan 
 *
 * Module  : Primitives.h
 *                                                                         
 * Purpose : Convertes Vrml's geometry primitives nodes.
 *          Currnetly supports cone, box, sphere & cylinder
 *                                                                      
 ****************************************************************************/

#ifndef PRIMITIVES_H
#define PRIMITIVES_H

/****************************************************************************
 Includes
 */

#include "_rpvrml.h"
#include "abstractnode.h"

/****************************************************************************
 Function prototypes
 */

#ifdef    __cplusplus
extern          "C"
{
#endif         /* __cplusplus */

    RwBool          Cone_Create(AbstractNode * an);
    RwBool          Box_Create(AbstractNode * an);
    RwBool          Sphere_Create(AbstractNode * an);
    RwBool          Cylinder_Create(AbstractNode * an);

/* stub functions for later implementation */
    RwBool          IndexedLineSet_Create(AbstractNode * an);
    RwBool          PointSet_Create(AbstractNode * an);
    RwBool          Text_Create(AbstractNode * an);

#ifdef    __cplusplus
}
#endif         /* __cplusplus */

#endif         /* PRIMITIVES_H */
