/****************************************************************************
 * 
 * VRML 2.0 to RW3.0 Converter
 * Copyright (C) 1998 Criterion Technologies
 *
 * Author  : Damian Scallan 
 *
 * Module  : PreWorldInfo.c
 *                                                                         
 * Purpose : Used to create an intermediate representation 
 *           of Abstract FaceSet nodes
 *                                                                         
 ****************************************************************************/

#ifndef PREWORLDINFO_H
#define PREWORLDINFO_H

/****************************************************************************
 Includes
 */

#include "_rpvrml.h"
#include "abstractnode.h"
#include "llinklist.h"
#include "types.h"

/****************************************************************************
 Global Types
 */

typedef struct faceLoop faceLoop;
struct faceLoop
{
    RwInt32 faceNum;
    RwInt32 index[3];
};

typedef struct PreWorldVertex PreWorldVertex;
struct PreWorldVertex
{
    RwInt32 vertexIndex;
    RwInt32 textureIndex;
    RwInt32 colourIndex;
    RwInt32 normalIndex;
};

#if 0
typedef struct PreWorldMorphTarget PreWorldMorphTarget;
struct PreWorldMorphTarget
{
    RwReal key;
    sfvec3f **vertices;
};
#endif /* 0 */

typedef struct PreWorldInfo PreWorldInfo;
struct PreWorldInfo
{
    /* flags */
    RwBool ccw;
    RwReal creaseAngle;
    RwBool coloursPerVertex;
    RwBool normalsPerVertex;

    /* vertices */
    RwInt32 numVertices;
    RwInt32 numTriFaces;
    sfvec3f **vertices;
    faceLoop *triFaces;

    /* morph target keyframes */
    RwInt32 numMorphTargets;
    sffloat *morphTargets;
    sfvec3f **morphTargetsValues;

    /* textures */
    RwInt32 numTextures;
    RwInt32 numTextureFaces;
    sfvec2f **textures;
    faceLoop *texFaces;

    /* colours */
    RwInt32 numColours;
    RwInt32 numColourFaces;
    sfcolor **colours;
    faceLoop *colourFaces;

    /* normals */
    RwInt32 numNormals;
    RwInt32 numNormalFaces;
    sfvec3f **normals;
    faceLoop *normalFaces;

    /* final remapped list */
    RwInt32 numFinalVertices;
    PreWorldVertex *finalVertices;
};



/****************************************************************************
 Function prototypes
 */

#ifdef    __cplusplus
extern "C"
{
#endif         /* __cplusplus */

/* creation / destruction */
PreWorldInfo *PreWorldInfo_Create(void);
RwBool PreWorldInfo_Destroy(PreWorldInfo *worldInfo);

/* vertices */
RwBool PreWorldInfo_SetVertices(PreWorldInfo *worldInfo, Field *verts);
RwBool PreWorldInfo_SetTriFaces(PreWorldInfo *worldInfo, Field *triFaces, RwInt32 numVerts, RwInt32 lineNum);

/* morph targets */
RwBool PreWorldInfo_SetMorphTargets(PreWorldInfo *worldInfo, LLinkList *keys, LLinkList *keyValues);

/* textures */
RwBool PreWorldInfo_SetTextures(PreWorldInfo *worldInfo, Field *textureList);
RwBool PreWorldInfo_SetTexFaces(PreWorldInfo *worldInfo, Field *texFaceList, RwInt32 numVerts, RwInt32 lineNum);
RwBool PreWorldInfo_SetDefaultTexFaces(PreWorldInfo *worldInfo);

/* colours */
RwBool PreWorldInfo_SetColours(PreWorldInfo *worldInfo, Field *colourList);
RwBool PreWorldInfo_SetColFaces(PreWorldInfo *worldInfo, Field *colFaceList, RwInt32 numVerts, RwInt32 lineNum);
RwBool PreWorldInfo_SetSolidColFaces(PreWorldInfo *worldInfo, Field *colFaceList);
RwBool PreWorldInfo_SetDefaultColFaces(PreWorldInfo *worldInfo);
RwBool PreWorldInfo_SetDefaultSolidColFaces(PreWorldInfo *worldInfo);

/* normals */
RwBool PreWorldInfo_SetNormals(PreWorldInfo *worldInfo, Field *normalList);
RwBool PreWorldInfo_SetNormalFaces(PreWorldInfo *worldInfo, Field *normFaceList, RwInt32 numVerts, RwInt32 lineNum);
RwBool PreWorldInfo_SetSolidNormalFaces(PreWorldInfo *worldInfo, Field *normalFaceList);
RwBool PreWorldInfo_SetDefaultNormalFaces(PreWorldInfo *worldInfo);
RwBool PreWorldInfo_SetDefaultSolidNormalFaces(PreWorldInfo *worldInfo);

/* remapping */
RwBool PreWorldInfo_SetFinalMapping(PreWorldInfo *worldInfo);

#ifdef    __cplusplus
}
#endif         /* __cplusplus */

#endif         /* PREWORLDINFO_H */
