
/****************************************************************************
 * 
 * VRML 2.0 to RW3.0 Converter
 * Copyright (C) 1997 Criterion Technologies
 *
 * Author  : Damian Scallan 
 *
 * Module  : Converter.h
 *                                                                         
 * Purpose : Takes the AbstractNode representation of a Vrml scene graph
 *          and converts it to a specific form
 *                                                                         
 ****************************************************************************/

#ifndef CONVERTER_H
#define CONVERTER_H

/****************************************************************************
 Includes
 */

#include "_rpvrml.h"
#include "abstractnode.h"

/****************************************************************************
 Defines
 */

/* used to scale converted objects */
#define SCALEFACTOR     (RwReal)(0.01)
#define LUMINANCE       (7.0)

/****************************************************************************
 Function prototypes
 */

#ifdef    __cplusplus
extern          "C"
{
#endif         /* __cplusplus */

extern RwBool          Convert_AbstractNodeList(LLinkList * abstractNodeList);
extern RwBool          Convert_Children(AbstractNode * an);

#ifdef    __cplusplus
}
#endif         /* __cplusplus */

#endif         /* CONVERTER_H */
