
/****************************************************************************
 *  
 * VRML 2.0 to RW3.0 Converter
 * Copyright (C) 1997 Criterion Technologies
 *
 * Author  : Damian Scallan 
 *
 * Module  : Builder.h
 *                                                                         
 * Purpose : Used by the Converter to construct the actual RW3.0 object
 *
 *                                                                         
 ****************************************************************************/

#ifndef BUILDER_H
#define BUILDER_H

/****************************************************************************
 Includes
 */

#include "_rpvrml.h"
#include "abstractnode.h"
#include "stack.h"
#include "types.h"

/****************************************************************************
 Global Types
 */
enum buildType
{
    CLUMP = 1, 
    WORLD = 2, 
    SCENE = 3,
    BUILDTYPEFORCEENUMSIZEINT = RWFORCEENUMSIZEINT
};
typedef enum buildType buildType;


enum geomType
{
    GEOM_STATIC = 1, 
    GEOM_DYNAMIC = 2,
    GEOMTYPEFORCEENUMSIZEINT = RWFORCEENUMSIZEINT
};
typedef enum geomType geomType;


/****************************************************************************
 Function prototypes
 */

#ifdef    __cplusplus
extern "C"
{
#endif         /* __cplusplus */

    RwBool Build_Init(void);
    void Build_Reset(void);
    RwBool Build_ConvertScene(void);
    void Build_Destroy(void);
    RwFrame *Build_PushFrame(RwFrame *frame);
    RwMatrix *Build_PushTransform(void);
    void Build_PopFrame(void);
    void Build_PopTransform(void);
    RwMatrix *Build_GetCurrentLTM(void);
    RwBool Build_AddAtomic(RpAtomic *atomic);
    RwBool Build_AddGeometry(RpGeometry *geometry);

    buildType Build_GetType(void);
    void Build_SetType(buildType bt);

    extern RtWorldImportVertex *Build_WorldAddMoreVertices(RwInt32 numVertices);
    extern RtWorldImportTriangle *Build_WorldAddMoreTriangles(RwInt32 numTriFaces);
    RwInt32 Build_WorldGetFaceIndOffset(void);
    RwInt32 Build_WorldGetVertexIndOffset(void);

    RpWorld *Build_WorldGet(void);
    RpClump *Build_ClumpGet(void);

    RwBool Build_SetScaleFactor(RwReal scaleFactor);
    RwReal Build_GetScaleFactor(void);

    RwBool Build_PushPivotOffset(sfvec3f *pivotOffet);
    RwBool Build_PopPivotOffset(void);
    sfvec3f *Build_GetPivotOffset(void);

    RwFrame *Build_GetCurrentFrame(void);

    geomType Build_GetGeomType(void);
    void Build_SetGeomType(geomType gt);
    RpClump *Build_NewBeginClump(void);

    void Build_WorldAccumulateFlags(RwInt32 flags);

    RwBool Build_SceneAddLight(RpLight *light);

#ifdef    __cplusplus
}
#endif         /* __cplusplus */

#endif         /* BUILDER_H */
