#ifndef _MATBLEND_H
#define _MATBLEND_H

#ifdef SKY2_DRVMODEL_H
#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */

/* ==== Types =================================*/
typedef struct RpMatBlendState RpMatBlendState;
struct RpMatBlendState
{
    RxPipeline             *AtomicGenericSkinPipe;
    RxPipeline             *AtomicPS2AllSkinPipe;
    RxPipeline             *AtomicPS2AllMatSkinPipe;
    RxWorldLightingCallBack lightingCallBack;
};

/* ==== Globals =================================*/
extern RpMatBlendState MatBlend;

/* ==== Common Defines =================================*/
#define VIFCMD_UNPACK  (0x6cl << 24)
#define VIFCMD_CYCLE   (0x01l << 24)
#define VIFCMD_DIRECT  (0x50l << 24)
#define VIFCMD_NOP     (0x00l << 24)

/* ==== External function needed to get Tex-0 info =====*/
extern RwRaster *
skyTexGetTex0(RwRaster *r, RwUInt32 *msb, RwUInt32 *lsb);

extern void
_rpSkinMBWeightsInstancing(const RpMesh *mesh, RpSkin *pSkin, RwReal *destMBI);

extern RwMatrix *
_rpSkinMBMatUpdating(RpAtomic *atomic, RpSkin *pSkin);

extern RxPipeline *
_rpSkinGetDefaultPipeline(void);

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* SKY2_DRVMODEL_H */

#include "genmatbl.h"

#endif /* _MATBLEND_H */
