/****************************************************************************
 *                                                                          *
 *  Module  :   patchdx7.c                                                  *
 *                                                                          *
 *  Purpose :   DX7 specific code for patches.                              *
 *                                                                          *
 ****************************************************************************/

/****************************************************************************
 Includes
 */

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string.h>

/* RW includes */
#include "rpplugin.h"
#include <rpdbgerr.h>
#include <rwcore.h>
#include <rpworld.h>
#include <rtbezpat.h>

#include "rppatch310.h"
#include "patchvar.h"
#include "patchgen.h"
#include "patchexp.h"

#include "nodeDX7PatchAtomicInstance.h"

#include "patchdx7.h"

#if (!defined(DOXYGEN))
static const char   rcsid[] __RWUNUSED__ =
    "@@@@(#)$Id: patchdx7.c,v 1.6 2001/09/25 15:37:30 iestynb Exp $";
#endif /* (!defined(DOXYGEN)) */

/****************************************************************************
 Local Defines
 */

/****************************************************************************
 Globals (across program)
 */

/****************************************************************************
 Functions
 */

RxPipeline         *
_rpPatchPipelineCreate(void)
{
    RxPipeline         *pipe;

    RWFUNCTION(RWSTRING("_rpPatchPipelineCreate"));

    pipe = RxPipelineCreate();
    if (pipe)
    {
        RxLockedPipe       *lpipe;

        pipe->pluginId = rwID_PATCHPLUGIN;

        if ((lpipe = RxPipelineLock(pipe)) != NULL)
        {
            RxPipelineNode     *node;

            lpipe = RxLockedPipeAddFragment(lpipe, NULL,
                                            RxNodeDefinitionGetDX7PatchAtomicInstance
                                            (),
                                            RxNodeDefinitionGetAtomicEnumerateLights
                                            (),
                                            RxNodeDefinitionGetMaterialScatter
                                            (), NULL);

            /* Make sure indices and D3D7 specific data clusters propagate to
             * the end of the pipeline, such that they can be passed to the
             * subsequent material pipelines.
             */
            node =
                RxPipelineFindNodeByName(lpipe,
                                         RxNodeDefinitionGetMaterialScatter
                                         ()->name, NULL, NULL);
            RxPipelineNodeRequestCluster(lpipe, node, &RxClIndices);
            RxPipelineNodeRequestCluster(lpipe, node,
                                         &RxClDX7VertexBufferInfo);

            lpipe = RxLockedPipeUnlock(lpipe);

            RWASSERT(pipe == (RxPipeline *) lpipe);
        }
    }

    RWRETURN(pipe);
}
