/****************************************************************************
 *                                                                          *
 *  Module  :   patchd3d8.c                                                  *
 *                                                                          *
 *  Purpose :   D3D8 specific code for patches.                              *
 *                                                                          *
 ****************************************************************************/

/****************************************************************************
 Includes
 */

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string.h>

/* RW includes */
#include "rpplugin.h"
#include <rpdbgerr.h>
#include <rwcore.h>
#include <rpworld.h>
#include <rtbezpat.h>

#include "rppatch310.h"
#include "patchvar.h"
#include "patchgen.h"
#include "patchexp.h"

#include "nodeD3D8PatchAtomicInstance.h"

#include "patchD3D8.h"

#if (!defined(DOXYGEN))
static const char   rcsid[] __RWUNUSED__ =
    "@@@@(#)$Id: patchD3D8.c,v 1.3 2001/09/24 12:39:30 johns Exp $";
#endif /* (!defined(DOXYGEN)) */

/****************************************************************************
 Local Defines
 */

/****************************************************************************
 Globals (across program)
 */

/****************************************************************************
 Functions
 */

RxPipeline         *
_rpPatchPipelineCreate(void)
{
    RxPipeline         *pipe;

    RWFUNCTION(RWSTRING("_rpPatchPipelineCreate"));

    pipe = RxPipelineCreate();
    if (pipe)
    {
        RxLockedPipe       *lpipe;

        pipe->pluginId = rwID_PATCHPLUGIN;

        if ((lpipe = RxPipelineLock(pipe)) != NULL)
        {
            lpipe = RxLockedPipeAddFragment(lpipe,
                NULL,
                RxNodeDefinitionGetD3D8PatchAtomicInstance(),
                NULL);

            lpipe = RxLockedPipeUnlock(lpipe);

            RWASSERT(pipe == (RxPipeline *) lpipe);
        }
    }

    RWRETURN(pipe);
}
