/****************************************************************************
 *                                                                          *
 *  Module  :   nodeOpenGLPatchAtomicInstance.c                             *
 *                                                                          *
 *  Purpose :   OpenGL Node for a custom power pipe to render patches.      *
 *                                                                          *
 ****************************************************************************/

#ifndef NODEOPENGLPATCHATOMICINSTANCE_H
#define NODEOPENGLPATCHATOMICINSTANCE_H

#include <rwcore.h>

/****************************************************************************
 Global types
 */

typedef struct RpPatchOpenGLAtomic RpPatchOpenGLAtomic;
struct RpPatchOpenGLAtomic
{

    RwBool              optimized; /* Vertex buffer should be optimized? */

    RxObjSpace3DVertex *vidMemVerts;

    RpPatchInstanceAtomic instAtomic; /* Must be last field because of the meshes
                                       * are after this. */
};

/****************************************************************************
 global prototypes
 */

/* RWPUBLIC */

#ifdef __cplusplus
extern              "C"
{
#endif                          /* __cplusplus */

extern RwGlExt      gl;

extern RxNodeDefinition * 
RxNodeDefinitionGetOpenGLPatchAtomicInstance(void);

#ifdef    __cplusplus
}
#endif                          /* __cplusplus */

/* RWPUBLICEND */

#endif                          /* NODEOPENGLPATCHATOMICINSTANCE_H */
