/****************************************************************************
 *                                                                          *
 *  Module  :   nodeDX7PatchAtomicInstance.c                                *
 *                                                                          *
 *  Purpose :   DX7 Node for a custom power pipe to render patches.         *
 *                                                                          *
 ****************************************************************************/

#ifndef NODEDX7PATCHATOMICINSTANCE_H
#define NODEDX7PATCHATOMICINSTANCE_H

#include <d3d.h>

#include <rwcore.h>

#include "patchexp.h"

/****************************************************************************
 Global vars
 */

extern LPDIRECT3D7  lpD3D7;

/* Device capabilities for currently selected d3d device */
extern D3DDEVICEDESC7 d3dGHardwareCaps;

/****************************************************************************
 Global types
 */

typedef struct RpPatchDX7Atomic RpPatchDX7Atomic;
struct RpPatchDX7Atomic
{

    RwBool              optimized; /* Vertex buffer should be optimized? */

    LPDIRECT3DVERTEXBUFFER7 vertexBuffer; /* Vertex buffer */

    RpPatchInstanceAtomic instAtomic; /* Must be last field because of the meshes
                                       * are after this. */
};

/****************************************************************************
 global prototypes
 */

/* RWPUBLIC */

#ifdef __cplusplus
extern              "C"
{
#endif                          /* __cplusplus */

/* RWPUBLICEND */

/* RWPUBLIC */

    extern              RxNodeDefinition
        * RxNodeDefinitionGetDX7PatchAtomicInstance(void);

#ifdef    __cplusplus
}
#endif                          /* __cplusplus */

/* RWPUBLICEND */

#endif                          /* NODEDX7PATCHATOMICINSTANCE_H */
