/****************************************************************************
 *                                                                          *
 *  Module  :   patchvar.h                                                  *
 *                                                                          *
 *  Purpose :                                                               *
 *                                                                          *
 ****************************************************************************/

#ifndef PATCHVAR_H
#define PATCHVAR_H

/****************************************************************************
 Includes
 */

#include "rwcore.h"
#include "rpworld.h"

#include "rpcriter.h"          /* Note: each vendor can choose their own
                                * method for allocation of unique ID's.
                                * This file defines the ID's used by Criterion.
                                */

#if (defined(SKY2_DRVMODEL_H))
#include "patchsky.h"          /* sky specific. */
#endif /* (defined(SKY2_DRVMODEL_H)) */

/****************************************************************************
 Defines
 */

#define RPPATCHPROP(_ptr, _offset) \
    ((void *) (((char *)(_ptr)) + (_offset)))

#define RPPATCHPROPCONST(_ptr, _offset) \
    ((const void *) (((const char *)(_ptr)) + (_offset)))

/* _res is the number of verts along the edge. */
#define RPPATCHQUADNUMVERT(_res) \
   ((_res) * (_res))

#define RPPATCHQUADNUMINDEX(_res) \
    ((2 * (_res)) * ((_res) - 1))

#define RPPATCHQUADNUMTRI(_res) \
    (2 * (_res - 1) * (_res - 1))

#define RPPATCHTRINUMVERT(_res) \
    (((_res) * ((_res) + 1)) / 2)

#define RPPATCHTRINUMINDEX(_res) \
    (((_res) - 1) * ((_res) + 1))

#define RPPATCHTRINUMTRI(_res) \
    ((_res - 1) * (_res - 1))

/****************************************************************************
 Global Vars
 */
#define RPPATCHVERSION              1

#define RPPATCHMAXLOD               14
#define RPPATCHMINLOD                4

#define RPPATCHDEFAULTMAXLOD        10
#define RPPATCHDEFAULTMINLOD         4

#define RPPATCHDEFAULTMINRANGE     (RwReal) 4.0
#define RPPATCHDEFAULTMAXRANGE     (RwReal) 200.0

#define RPPATCHVERTPOSTOL           1.0e-4
#define RPPATCHVERTNRMTOL           0.5

/****************************************************************************
 Global Types
 */

typedef struct RpPatchGeomExt RpPatchGeomExt;

struct RpPatchGeomExt
{
    RwInt32             version;
    RwInt32             flag;

    RpPatch            *patch;
};

typedef struct RpPatchAtomicExt RpPatchAtomicExt;

struct RpPatchAtomicExt
{
    RwInt32             version;
    RwInt32             flag;

    RwInt32             numQuadPatch, numTriPatch;

    RpPatch            *patch;
};

typedef struct RpPatchCameraExt RpPatchCameraExt;

struct RpPatchCameraExt
{
    RwCameraBeginUpdateFunc oldBeginUpdate;
    RwCameraEndUpdateFunc oldEndUpdate;
};

typedef struct rpPatchGlobalVars RpPatchGlobalVars;

struct rpPatchGlobalVars
{
    RwInt32             engineOffset; /* Offset into global data */

    RwInt32             atomicExtOffset; /* Offset into global data */
    RwInt32             geomExtOffset; /* Offset into global data */
    RwInt32             cameraExtOffset; /* Offset into global data */

    RwFreeList         *patchFreeList;
    RwFreeList         *patchNodeFreeList;
    RwFreeList         *patchMaterialFreeList;

    RwReal              minAtomicRange;
    RwReal              maxAtomicRange;
    RwReal              recipAtomicRange;

    RwInt32             minAtomicLOD;
    RwInt32             maxAtomicLOD;
    RwReal              deltaAtomicLOD;

    RwReal              vertNrmTol;
    RwReal              vertPosTol;

    RwReal              emapParams[4];

    RwMatrix            invCamMatrix;
    RwFrame            *camFrame;

    RpPatchAtomicLODCallBack atomicLODCallBack;

    RxPipeline         *atomicObjectPipe;
    RxPipeline         *atomicGEMObjectPipe;

#ifdef SKY2_DRVMODEL_H

    /* Additional data for sky build. */
    RpPatchSkyGlobals   sky;

#endif                          /* SKY2_DRVMODEL_H */

};

extern RpPatchGlobalVars rpPatchGlobals;

/****************************************************************************
 Function prototypes
 */

#ifdef __cplusplus
extern              "C"
{
#endif                          /* __cplusplus */

#ifdef    __cplusplus
}
#endif                          /* __cplusplus */

#endif                          /* PATCHVAR_H */
