/****************************************************************************
 *                                                                          *
 *  Module  :   patchop .c                                                  *
 *                                                                          *
 *  Purpose :   Misc patch operations.                                      *
 *                                                                          *
 ****************************************************************************/

#ifndef PATCHOP_H
#define PATCHOP_H

/****************************************************************************
 Includes
 */
#include "rwcore.h"
#include "rpworld.h"

#include "rppatch310.h"

/****************************************************************************
 Local Defines
 *
 */
#define RPPATCHIDXTABLESIZE    8

/****************************************************************************
 Local Types
 */

typedef struct RpPatchIdxTable RpPatchIdxTable;

struct RpPatchIdxTable
{
    RwInt32             count;
    RwInt32             size;
    RxVertexIndex      *idx;
};

/****************************************************************************
 Function prototypes
 */

#ifdef __cplusplus
extern              "C"
{
#endif                          /* __cplusplus */

    extern RpPatch     *_rpPatchSmoothNormal(RpPatch * patch,
                                            RwV3d * smnrm);

#ifdef __cplusplus
}
#endif                          /* __cplusplus */

#endif                          /* PATCHOP.H */
