/****************************************************************************
 *                                                                          *
 *  Module  :   patchexp.h                                                  *
 *                                                                          *
 *  Purpose :   Expand a patch atomic object into a set of meshes suitable  *
 *              for rendering.                                              *
 *                                                                          *
 ****************************************************************************/

#ifndef PATCHEXP_H
#define PATCHEXP_H

/****************************************************************************
 Includes
 */

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string.h>

/* RW includes */
#include "rpplugin.h"
#include <rpdbgerr.h>
#include <rwcore.h>
#include <rpworld.h>

/****************************************************************************
 Local Defines
 */

/****************************************************************************
 Globals (across program)
 */
typedef struct RpPatchInstanceMesh RpPatchInstanceMesh;
struct RpPatchInstanceMesh
{
    RxVertexIndex      *indices;
    RwUInt32            numIndices;
    RwUInt32            minVert, numVerts;
    RpMaterial         *material;
    RpMesh             *mesh;
};

typedef struct RpPatchInstanceAtomic RpPatchInstanceAtomic;
struct RpPatchInstanceAtomic
{
    RwUInt32            serialNum; /* Serial # - combination of
                                    * elements contributing to
                                    * instanced data.  Enables us to
                                    * detect when a re-instance is
                                    * necessary.
                                    */

    RxVertexIndex      *indices; /* Vertex index buffer. */

    RxObjSpace3DVertex *vertices; /* We also keep the vertices around for
                                   * generic nodes and software lighting
                                   * to play around with */

    RwInt32             numMeshes; /* The number of meshes */
    RwInt32             totalIndices; /* The total number of indices */
    RwInt32             totalVerts; /* The total number of verts */
    RwInt32             res;    /* Resolution of the facetting. */

    RpPatchInstanceMesh meshes[1]; /* The meshes :-) */
};

/****************************************************************************
 Function prototypes
 */

extern              RwBool
_rpPatchInstanceAtomic(RpPatchInstanceAtomic * instAtomic,
                       RpAtomic * atomic, RwInt32 res);

#endif /* PATCHEXP_H */
