/*----------------------------------------------------------------------*
 *                                                                      *
 * Module  : effectPipesSoftras.c                                       *
 *                                                                      *
 * Purpose :                                                            *
 *                                                                      *
 * FX      :                                                            *
 *----------------------------------------------------------------------*/

/*----------------------------------------------------------------------*
 *-   Includes                                                         -*
 *----------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/*==== RW libs includes =====*/
#include "rpplugin.h"
#include <rpdbgerr.h>
#include <rwcore.h>
#include <archive/rpmatfx310.h>

#include "effectpipes.h"

#if (!defined(DOXYGEN))
static const char rcsid[] __RWUNUSED__ = 
    "@@@@(#)$Id: effectPipesSoftras.c,v 1.3 2001/09/26 10:48:13 johns Exp $";
#endif /* (!defined(DOXYGEN)) */

/*----------------------------------------------------------------------*
 *-   Local Types                                                      -*
 *----------------------------------------------------------------------*/

/*----------------------------------------------------------------------*
 *-   Local/static Globals                                             -*
 *----------------------------------------------------------------------*/

/*----------------------------------------------------------------------*
 *-   Globals across program                                           -*
 *----------------------------------------------------------------------*/

/*----------------------------------------------------------------------*
 *-   Defines                                                          -*
 *----------------------------------------------------------------------*/

/*----------------------------------------------------------------------*
 *-   Functions                                                        -*
 *----------------------------------------------------------------------*/

/*--- Create and destory pipelines ------------------------------------------*/
RwBool
_rpMatFXPipelinesCreate(void)
{
    RWFUNCTION(RWSTRING("_rpMatFXPipelinesCreate"));
    RWRETURN(TRUE);
}

RwBool
_rpMatFXPipelinesDestroy(void)
{
    RWFUNCTION(RWSTRING("_rpMatFXPipelinesDestroy"));
    RWRETURN(TRUE);
}

/*--- Attach pipelines ------------------------------------------------------*/
RpAtomic           *
_rpMatFXPipelineAtomicSetup(RpAtomic * atomic)
{
    RWFUNCTION(RWSTRING("_rpMatFXPipelineAtomicSetup"));
    RWASSERT(atomic);
    RWRETURN(atomic);
}

RpWorldSector      *
_rpMatFXPipelineWorldSectorSetup(RpWorldSector * worldSector)
{
    RWFUNCTION(RWSTRING("_rpMatFXPipelineWorldSectorSetup"));
    RWASSERT(worldSector);
    RWRETURN(worldSector);
}

/*--- Enable effects --------------------------------------------------------*/
RpMaterial         *
_rpMatFXEnvMapEnable(RpMaterial * material)
{
    RWFUNCTION(RWSTRING("_rpMatFXEnvMapEnable"));
    RWRETURN(material);
}

RpMaterial         *
_rpMatFXBumpMapEnable(RpMaterial * material)
{
    RWFUNCTION(RWSTRING("_rpMatFXBumpMapEnable"));
    RWRETURN(material);
}

RpMaterial         *
_rpMatFXDualEnable(RpMaterial * material)
{
    RWFUNCTION(RWSTRING("_rpMatFXDualEnable"));
    RWRETURN(material);
}

/*--- Upload texture --------------------------------------------------------*/

/*--- Device data fucntions -------------------------------------------------*/
RwBool
_rpMatFXSetupDualRenderState(MatFXDualData * __RWUNUSEDRELEASE__ dualData,
                             RwRenderState __RWUNUSED__ nState)
{
    RWFUNCTION(RWSTRING("_rpMatFXSetupDualRenderState"));
    RWASSERT(dualData);
    RWRETURN(TRUE);
}

RwTexture *
_rpMatFXSetupBumpMapTexture(const RwTexture *baseTexture,
                            const RwTexture *effectTexture)
{
    RwTexture *texture;
    RWFUNCTION(RWSTRING("_rpMatFXSetupBumpMapTexture"));

    texture = _rpMatFXTextureMaskCreate(baseTexture, effectTexture);

    RWRETURN(texture);
}

