/*
 *  effectPipesGcn.h
 *
 *  GCN specific versions of the data for the standard effects.
 *
 *  See multiTexGcn.h for GameCube platform specific material 
 *  data management (multitexturing). That module may be compiled in with
 *  null builds.
 */

#ifndef EFFECTPIPESGCN_H
#define EFFECTPIPESGCN_H

/*===========================================================================*
 *--- Include files ---------------------------------------------------------*
 *===========================================================================*/
#include <rwcore.h>
#include <rpworld.h>

/*===========================================================================*
 *--- Defines ---------------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Types -----------------------------------------------------------------*
 *===========================================================================*/
struct MatFXDualData
{
    RwTexture          *texture;
    RwBlendFunction     srcBlendMode;
    RwBlendFunction     dstBlendMode;
    /*--- device specific ---*/
};

struct MatFXBumpMapData
{
    RwFrame   *frame;
    RwTexture *texture;
    RwTexture *bumpTexture;
    RwReal    coef;
    RwReal    invBumpWidth;
};

/*===========================================================================*
 *--- Public Global Variables -----------------------------------------------*
 *===========================================================================*/

#endif /* EFFECTPIPESGCN_H */
