/*
 * This comment is generated by the RCS co command:
 * $Id: osintf.c,v 1.6 2001/07/05 08:25:55 johns Exp $
 * <file name> <rev> <date & time> <author> <state> <currently locked by>
 */
/**********************************************************************
 *
 * File:     lxintf.c
 *
 * Abstract: Code to provide a device independent interface between
 *           RenderWare and the host operating system. Currently,
 *           only a minimal set of functions are implemented here.
 *           These should be added to over time.
 *
 *           This is the DOS version.
 *
 * Modification history:
 * (13/05/93) (CMcC) Created this file.
 *
 **********************************************************************/

#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <unistd.h>

#include "osintf.h"

#include "balibtyp.h"

static const char   rcsid[] __RWUNUSED__ =
    "@@(#)$Id: osintf.c,v 1.6 2001/07/05 08:25:55 johns Exp $";

/**********************************************************************/

int
_rwpathisabsolute(const RwChar * path)
{

    int                 result;

    RWFUNCTION(RWSTRING("_rwpathisabsolute"));
    RWASSERT(path);

    result = ((path) &&
              ((*path == SLASH) ||
               (isalpha(*path) && (path[1] == ':'))));

    RWRETURN(result);
}

/**********************************************************************/

/* Get current time string */
RwChar             *
_rwgetcurrenttime(RwChar * buffer __RWUNUSEDRELEASE__, 
                  RwInt32 bufSiz __RWUNUSED__)
{
    RwChar             *result = (RwChar *) NULL;

    RWFUNCTION(RWSTRING("_rwgetcurrenttime"));

    RWASSERT(buffer);

    /* On PS2 - no valid time is available so simply return NULL */

    RWRETURN(result);
}

/**********************************************************************
 *
 * End of file.
 *
 **********************************************************************/
