; ----------------------------------------------------------------------
; Warning: This file will be processed using a rather simple sed script
; to turn it into a C include file.
;
; sed -e "s/\([^;]*\);/\1\/\//"					\
;     -e "s/^\.if/#if/" -e "s/^\.else/#else/" -e "s/^\.endif/#endif/"	\
;     -e "s/^\.equ\([ 	][^,]*\),/#define\1/" -e "s/vuSymb/pipeASymb/g"
;                    ^-[ space TAB ]  [ pipe specific prefix]--^
; Sorry about the C++ style comments this generates.
; ----------------------------------------------------------------------

; Enums
.ifndef vuEnumLightNaLight
; Warning these must be reconciled with the C enums.
; Check auto-generated file "baequate.i"

.equ vuEnumLightNaLight, 0      ; rpNALIGHTTYPE
.equ vuEnumLightDirectional, 1  ; rpLIGHTDIRECTIONAL
.equ vuEnumLightAmbient, 2      ; rpLIGHTAMBIENT
.equ vuEnumLightPoint, 128      ; rpLIGHTPOINT
.equ vuEnumLightSpot, 129       ; rpLIGHTSPOT
.equ vuEnumLightSpotSoft, 130   ; rpLIGHTSPOTSOFT

.endif

; Data in high memory

.ifndef vuSDmat0

.equ vuSDBlockLow, 0x3c3
.equ vuSDBlockHigh, 0x3f0

.equ vuSDmat0, vuSDBlockHigh
.equ vuSDmat1, vuSDBlockHigh+1
.equ vuSDmat2, vuSDBlockHigh+2
.equ vuSDmat3, vuSDBlockHigh+3
.equ vuSDnearClip, vuSDBlockHigh+4
.equ vuSDfarClip, vuSDBlockHigh+5
.equ vuSDxMaxyMax, vuSDBlockHigh+6
.equ vuSDcamWcamHzScale, vuSDBlockHigh+7
.equ vuSDoffXoffYzShift, vuSDBlockHigh+8
.equ vuSDrealOffset, vuSDBlockHigh+9
.equ vuSDgifTag, vuSDBlockHigh+10
.equ vuSDcolScale, vuSDBlockHigh+11
.equ vuSDsurfProps, vuSDBlockHigh+12 ; Where enabled, morph scale in w.
.equ vuSDpingPongAddr, vuSDBlockHigh+13	; x = Out0 address,
                                        ; y = Out1 address,
					; z = In address
.equ vuSDpingPongCount, vuSDBlockHigh+14	; x = Out vert count,
                                        ; y = Out prim count,
					; z = In vert count,w = In prim count
					
.equ vuSDClipvec1, vuSDBlockHigh+13	; First clipping Vector 
									; 1/xscreen , xscreen , nearc , zmap1	
.equ vuSDClipvec2, vuSDBlockHigh+14	; Second clipping Vector 
									; 1/yscreen , yscreen , farc , zmap2					
.equ vuSDVUSwitch, vuSDBlockHigh+15	; Dynamic Switches
									; user , user , flags , jump
.equ vuSDLightOffset, 0x3d0

.endif

; ----------------------------------------------------------------------
; Put your Pipe specific static data here
; Names should probably be in the "vuSymb" name space


; ----------------------------------------------------------------------
; You must set these correctly for the amount of data above and the size
; of the vertex data. vuSymbStrideOfInputCluster will generally be the same
; as the number of clusters that you RpFXBridgeNodeRequestCluster() from
; nodePS2MatBridgeCSL. vuSymbStrideOfOutputCluster will generally be the NREG
; value in the gif tag if the output cluster is dispatched to GS

.equ vuSymbStrideOfInputCluster, 4
.equ vuSymbStrideOfOutputCluster, 3

; Set the base of the high memory data here
.equ vuSymbStaticDataStart, 0x3c3

; ----------------------------------------------------------------------
; It should be unnecessary to change any of the defines below this line.

; The following is calculated giving the VIF Offset for UNPACK double buffering
.equ vuSymbVIFOffset, (vuSymbStaticDataStart/2)

; The following are offsets for tristrips. They allow enough space that the
; incomming tristrip can be broken in half and dispatched as two parts.
; This makes multipass easier

; vuSymbTSVertexCount is a slight under estimate due to rounding
.equ vuSymbTSVertexCount, ((vuSymbVIFOffset-2-3*vuSymbStrideOfOutputCluster)/(vuSymbStrideOfInputCluster+vuSymbStrideOfOutputCluster))
.equ vuSymbTSOutGif, (vuSymbTSVertexCount*vuSymbStrideOfInputCluster)
.equ vuSymbTSOutBuf, (vuSymbTSOutGif+1)
.equ vuSymbTSOutGif2, (vuSymbTSOutBuf+((vuSymbTSVertexCount+3)/2)*vuSymbStrideOfOutputCluster)
.equ vuSymbTSOutBuf2, (vuSymbTSOutGif2+1)
.equ vuSymbTSOutHBVC, ((vuSymbTSVertexCount+3)/2)
.equ vuSymbTSOutHBTC, (vuSymbTSOutHBVC-2)

; The following are offsets for trilists. They allow enough space that the
; incomming trilist can be dispatched at 1 giftag per triangle! This allows
; for a special case (True clipping)

; vuSymbTLTriCount is a slight under estimate due to rounding
.equ vuSymbTLTriCount, ((vuSymbVIFOffset-(3*vuSymbStrideOfOutputCluster+1))/(3*(vuSymbStrideOfInputCluster+vuSymbStrideOfOutputCluster)+1))
.equ vuSymbTLOutGif, (vuSymbTLTriCount*3*vuSymbStrideOfInputCluster)
.equ vuSymbTLOutBuf, (vuSymbTLOutGif+1)
; vuSymbTLOutGif2 depends on vuSymbTLOutGif, not vuSymbTLOutBuf
.equ vuSymbTLOutGif2, (vuSymbTLOutGif+((vuSymbTLTriCount+1)/2)*(3*vuSymbStrideOfOutputCluster+1))
.equ vuSymbTLOutBuf2, (vuSymbTLOutGif2+1)
.equ vuSymbTLOutHBTC, ((vuSymbTLTriCount+1)/2)
.equ vuSymbTLOutHBVC, (vuSymbTLOutHBTC*3)

; The following are offsets for pointlists. They allow only enough space
; for one output vertex per input vertex... we can't really make a
; reasonable guess since we don't know what you're expanding the points
; into... it could be anything! (e.g bezier control points -> 2n^2 triangles!)

; vuSymbPLPointCount is a slight under estimate due to rounding
.equ vuSymbPLPointCount, ((vuSymbVIFOffset-2-vuSymbStrideOfOutputCluster)/(vuSymbStrideOfInputCluster+vuSymbStrideOfOutputCluster))
.equ vuSymbPLOutGif, (vuSymbPLPointCount*vuSymbStrideOfInputCluster)
.equ vuSymbPLOutBuf, (vuSymbPLOutGif+1)
; vuSymbPLOutGif2 depends on vuSymbPLOutGif, not vuSymbPLOutBuf
 equ vuSymbPLOutGif2, (vuSymbPLOutGif+((vuSymbPLPointCount+1)/2)*vuSymbStrideOfOutputCluster)
.equ vuSymbPLOutBuf2, (vuSymbPLOutGif2+1)
.equ vuSymbPLOutHBTC, ((vuSymbPLPointCount+1)/2)
.equ vuSymbPLOutHBVC, (vuSymbPLOutHBTC)
; ----------------------------------------------------------------------
