/* SCEI CONFIDENTIAL
 "PlayStation 2" Programmer Tool Runtime Library  Release 2.0
 */
/* 
 *              Emotion Engine Library Sample Program
 *
 *                      - object handler -
 *
 *                         Version 0.10
 *                           Shift-JIS
 *
 *      Copyright (C) 1998-1999 Sony Computer Entertainment Inc.
 *                        All Rights Reserved.
 *
 *                            obsimpl.c
 *
 *       Version        Date            Design      Log
 *  --------------------------------------------------------------------
 *	0.1		Jul,13,1998	suzu	    1st version
 *	0.2		Dec,23,1999	suzu	    changed for libgraph
 *	0.3		May,13,1999	suzu	    add comment
 */
// IuWFNgnhCX^X̗B
// CX^X֐ɂ͈ȉ̗Ⴊ܂
//
// ----------------------------------------------------------------------
// objnorm.c		@\dWIȃCX^X
// objsimpl.c		@\dȗCX^X
// objfast.c		xdVvȃCX^X
// objfastA.c		xdVvȃCX^XiAZuj
// ----------------------------------------------------------------------
//
// objsimpl.c  objfast.c ȉ̋@\܂BŜ̗
// mɂ͍ŏ objfast.c QƉB
//
// [g@\]
// 1.hbvVhE̕\
//	[hWn z = 0 ̖ʂɃhbvVhE`悵܂
//	VhȆΏۂƂȂ 0  (ld0) ݂̂ł
//
// 2. _
//	_vZiȂjsȂ܂BΏۂƂȂ͂O (ld0)
//	݂̂łBȓ_vZł͒_ƂɁAZ𔺂K
//	߂܂B̂߁AxNgIuWFNg̑\_
//	΂Ă݈̂xsȂAIuWFNg̊e_֑΂x
//	Ng͓l𗬗p邱ƂLłB
//
// 3. Nbv`FbN
//	Rp`Ƃ̌ȕ`NbvsȂ܂BẽIuWFN
//	ǧ`󂪑傫ꍇ̓IuWFNgPʂ̃Nbvł͐mȕ\
//	łȂꍇ܂B̏ꍇ̓v~eBuPʂ̃Nbs
//	OKvɂȂ܂
//
// 4. XyL
//	CgxN^͋K񐔂ׂ悳XyLʂ܂B
//
#include "object.h"
#ifndef OPENGL

static inline void _CopyVector(VECTOR v0, VECTOR v1)
{
	asm ("
	lq    $6,0x0(%1)
	sq    $6,0x0(%0)
	": : "r" (v0) , "r" (v1):"$6");
}
#endif

qword *objDrvSimple(qword *pbase, OBJECT *obj) 
{
	int	i, j, nv, flag;
	VECTOR	c, v, n, c1, v1, lp, li, cs, ld0;
	VECTOR	*cvnt;
	MATRIX	wm, mw, ms;
	MATRIX	wsh, ssh;
	qword	*pshadow;
	qword	vi;
	
	// set model-screen matrix
	MulMatrix(ms, obj->view->ws,  obj->mw[0]);

	// make light direction
	if (obj->light->model == 1) 
		ScaleVector(ld0, obj->light->ld0, -1);
	else 
		SubVector(ld0, obj->light->lp0, obj->mw[0][3]);
	

	// set drop shadow matrix
	DropShadowMatrix(wsh, ld0, 0, 0, 1, 0);
	MulMatrix(mw,  wsh, obj->mw[0]);
	MulMatrix(ssh, obj->view->ws,  mw);

	// translate to local
	InversMatrix(wm, obj->mw[0]);
	ApplyMatrix(lp, wm, obj->light->lp0);
	ApplyMatrix(ld0, wm, ld0);

	// normalize
	ld0[3] = 0;
	Normalize(ld0, ld0);
	ScaleVector(ld0, ld0, obj->light->lc[0][0]);

	// set shadow color
	setVector(cs, 0, 0, 0, 0);	
	
	// main loop
	cvnt  = obj->cvnt;
	while ((nv = cvnt[0][3]) > 0) {
			
		// set shadow pointer (GIFtag + nv*(vertex+color)
		pshadow = pbase + 1+nv*2;	

		// set tag
		obj->tag[0] = 0x8000 | nv;
		_CopyVector((float *)(*pbase++),   (float *)obj->tag);
		_CopyVector((float *)(*pshadow++), (float *)obj->tag);			

		// project each vertex
		cvnt++;
		for (i = flag = 0; i < nv; i++, cvnt++) {

			_CopyVector(c, obj->c? obj->c[0]: cvnt[0]);
			_CopyVector(v, cvnt[nv]);
			_CopyVector(n, cvnt[nv+nv]);

			v[3] = 1;
			n[3] = 0;

			// rot-trans-pers
			ApplyMatrix(v1, ms, v);
			DivVectorXYZ(v1, v1, v1[3]);

			// clip check
			if (obj->clip) 
				flag = (flag<<1 | (ClipScreen(v1)? 1: 0));

			// lighting
			if (flag == 0 && obj->light->model) {

				// spot light
				if (obj->light->model == 3) {			
					SubVector(ld0, lp, v);
					Normalize(ld0, ld0);
					ScaleVector(ld0,ld0,obj->light->lc[0][0]);
				}

				// light influence
				li[0] = InnerProduct(ld0, n);
				if (li[0] < 0.0f) li[0] = 0.0f;

				// specular
				for (j = 0; j < obj->spec; j++)
					MulVector(li, li, li);

				// set material
				li[0] =  li[0] + obj->light->lc[3][0];

				ScaleVector(c1, c, li[0]);

				// cast to integer
				Int0Vector(*pbase++, c1);

			}
			else
				Int0Vector(*pbase++, c);
		
			// cast to integer
			Int4Vector(vi, v1);
			
			// clip
			vi[3] = flag? 0x8000: 0;

			// add to display list
			_CopyVector((float *)(*pbase++), (float *)vi);

			// RotTransPers
			if (obj->shadow) {
				// shadow vertex
				ApplyMatrix(v1, ssh, v);
				DivVectorXYZ(v1, v1, v1[3]);
				Int4Vector(vi, v1);
				vi[3] = flag? 0x8000: 0;
	
				// add to display list
				_CopyVector((float *)(*pshadow++), cs);
				_CopyVector((float *)(*pshadow++), (float *)vi);
			}
		}
		cvnt  += 3*nv;
		if (obj->shadow)
			pbase = pshadow;
	}
	return(pbase);
}
