/* SCEI CONFIDENTIAL
 "PlayStation 2" Programmer Tool Runtime Library  Release 2.0
 */
/* 
 *              Emotion Engine Library Sample Program
 *
 *                      - object handler -
 *
 *                         Version 0.10
 *                           Shift-JIS
 *
 *      Copyright (C) 1998-1999 Sony Computer Entertainment Inc.
 *                        All Rights Reserved.
 *
 *                            object.c
 *
 *       Version        Date            Design      Log
 *  --------------------------------------------------------------------
 *	0.1		Jul,13,1998	suzu	    1st version
 *	0.2		Dec,23,1999	suzu	    changed for libgraph
 *	0.3		May,13,1999	suzu	    add comment
 */
#include "object.h"

// ---------------------------------------------------------------------
// 
// 			Matrix Utility
// 
// ---------------------------------------------------------------------
//	
// r[sƃCgsvZ邽߂̃[eBeBvOłB
// updateView()  updateLight() 肻ꂼ꒸_WA_Px
// l߂邽߂̍svZ܂B
// e\̂̃ȍڍׂ object.h QƉB	
//	
// updateView:
// 	WIȃr[XN[svZ܂B
// 	̏ڍׂ libvu0 ̃hLgQƉB
//
// updateLight:
//	 WIȃm[}CgACgJ[svZ܂
//	 ͌̕_ƌ̈ʒuƂԃxN^ƂĒ`܂B
//
//  set conventional view-screen matrix 
//  offset = (2048, 2048),
// (zmin, zmax) = (1, 16777215), (nearz, farz) = 65536

// update SCREEN and VIEW structure
void updateView(SCREEN *screen, VIEW *view)
{
	// update SCREEN
	ViewScreenMatrix(screen->vs, screen->scrz, screen->ax, screen->ay, 
			 2048.0, 2048.0, 0.0, 16777215.0, 64.0, 65536.0); 
	
	// update VIEW
	CameraMatrix(view->wv, view->p, view->zd, view->yd);
	MulMatrix(view->ws, screen->vs, view->wv);
}

// update LIGHT structure
void updateLight(LIGHT *light)
{
	ScaleVector(light->ld0, light->lp0, -1);
	ScaleVector(light->ld1, light->lp1, -1);
	ScaleVector(light->ld2, light->lp2, -1);
	NormalLightMatrix(light->nl, light->ld0, light->ld1, light->ld2);
	LightColorMatrix(light->lc,  light->c0,  light->c1,  light->c2, light->a);
}
// -----------------------------------------------------------
// 
// 			GIFTag Handler
// 
// ------------------------------------------------------------
// GIFtag 쐬܂B
// ōꂽ GIFtag ̓IuWFNg\SẴXgbvb
// VɂēKp܂
//
// abe		1 w肷ƃufBOLɂȂ܂
// fge		1 w肷ƃtHOLɂȂ܂
// tme		1 w肷ƃeNX`}bsOLɂȂ܂
// iip		1 w肷ƃO[[VF[fBOLɂȂ܂

// make GIFtag
void objMakeTag(OBJECT *obj, int abe, int fge, int tme, int iip)
{
	abe = fge = tme = 0;

	obj->tag[0] = 0;
	obj->tag[1] = 0;
	obj->tag[2] = 0x41;		// regs = (RGBAQ, XYZF)
	obj->tag[1] |= 0x02<<28;	// nreg = 2
	obj->tag[1] |= 0   <<26;
	obj->tag[1] |= abe <<21;	// abe
	obj->tag[1] |= fge <<20;	// fge	
	obj->tag[1] |= 0   <<19;	// tme	
	obj->tag[1] |= iip <<18;	// iip
	obj->tag[1] |= 4   <<15;	// prim
	obj->tag[1] |= 1   <<14;	// pre
	obj->tag[0] |= 1   <<15;	// eop
}

// -----------------------------------------------------------
// 
// 			Object Handler
// 
// ------------------------------------------------------------
//
// IuWFNgnhNX
//
// IuWFNg̑̂߂̊֐ňȉ̂̂܂B
//	
// objInit()
//	pPbg̃ZbgAbvBOŊ蓖ĂꂽpPbgobt@
//	Z[u܂B̍ۃobt@͔LbV̈ƂĈ܂B
//
// objFlush()
// 	쐬ꂽfBXvCXg DMA pđM܂B
// 	Path1 ̑M̓\[X`FC[hgp܂B̂߃pPb
//	g̍ŌɏI[R[h(0x70000000) ǉ܂B
// 	Path3 ̑M̓m[}[hgp܂Bۂ scePP3_Kick() 
// 	ŕ DMA pPbgɕꍇ܂B
// 	ڍׂ́Asce_pp3.c QƉB
//
// objDraw()
//	IuWFNgWϊăfBXvCXg֒ǉ܂B
// 	ۂ̕ϊ obj \̂Ŏw肳ꂽCX^X֐s
//	܂BCX^X֐ւ邱ƂɂOdlւ
//	ɈقȂ铮Lq邱Ƃ 3DCG ŒʏɍsȂJvZ
//	̎@łB 	
// 	CX^X֐ĂяoOɂ̓{bNX`FbNɂIuWF
//	NgPʂ̉ʃNbv`FbNsȂ܂BEfBO{b
//	NX̓_Sĕ\̈OłΈȍ~̏̓LZ܂B
//
// fBXvCXg̃
//	fBXvCXg̏o͂LbVƂ܂BfBXvC
//	Xg̏o͈͂UCg΍ĂюQƂ邱ƂȂ߃Lb
//	VC֍ڂKv܂BAhXLbVA
//	NZX邩LbVANZX邩̓AhX̏ 8bit 
//	wł܂BADDRMASK ̒`QƉB
//
// fBXvCXgobt@̃|C^
//	 PS2 ł Path1/Path3 ̂Q̃fBXvCXg𓯎Ɉ
//	Ƃł܂B̃vOł́ApXƂɈقȂȉ 
//	global ϐgp܂B
//	
//	pbase1		Path1 JgpPbg|C^
//	pstart1		Path1 pPbg|C^x[XAhX
//	pbase3		Path3 JgpPbg|C^
//	pstart3		Path3 pPbg|C^x[XAhX
//

#ifdef OPENGL
#define ADDRMASK	0x00000000
#else
#define ADDRMASK	0x20000000
#endif

// packet base
static qword	*pbase1, *pstart1 = 0;
static qword	*pbase3, *pstart3 = 0;

// setup packet
void objInit(qword *base1, qword *base3)
{
	pbase1 = pstart1 = base1;	
	pbase3 = pstart3 = base3;

	if (base1) 
		pbase1 = (qword *)(ADDRMASK|(u_int)pbase1);
	if (base3)
		pbase3 = (qword *)(ADDRMASK|(u_int)pbase3);

	FlushCache(0);
}

// kick
void objFlush()
{
	// wait
	scePP13_Sync();

	// path1 termination
	if (pstart1) {
		pbase1[0][0] = 0x70000000;
		pbase1[0][1] = pbase1[0][2] = pbase1[0][3] = 0;
		scePP1_Kick(pstart1);
	}

	// path3 mask disable
	if (pstart3) {
		pbase3 = (qword *)(~ADDRMASK&(u_int)pbase3);
		scePP3_Kick((u_int *)pstart3, pbase3 - pstart3);
	}
}

// add object
void objDraw(OBJECT *obj)
{
	// clip check
	if (obj->box) {
		static VECTOR	minv = {2048-640/2, 2048-224/2, 0,    64};
		static VECTOR	maxv = {2048+640/2, 2048+224/2, 0, 32767};

		MATRIX	ms;
		MulMatrix(ms, obj->view->ws,  obj->mw[0]);
		if (ClipAll(minv, maxv, ms, obj->box, 8)) 
			return;
	}

	// kick
	if (obj->driver1 && pbase1)
	  pbase1 = (obj->driver1)(pbase1, obj);

	if (obj->driver3 && pbase3)
	  pbase3 = (obj->driver3)(pbase3, obj);

}
