
/****************************************************************************
 *
 * This file is a product of Criterion Software Ltd.
 *
 * This file is provided as is with no warranties of any kind and is
 * provided without any obligation on Criterion Software Ltd.
 * or Canon Inc. to assist in its use or modification.
 *
 * Criterion Software Ltd. and Canon Inc. will not, under any
 * circumstances, be liable for any lost revenue or other damages
 * arising from the use of this file.
 *
 * Copyright (c) 2001 Criterion Software Ltd.
 * All Rights Reserved.
 *
 */

/****************************************************************************
 *
 * clmpdmrf.c
 *
 * Copyright (C) 2001 Criterion Technologies.
 *
 * Original author: Matt Thorman
 * Reviewed by:
 *
 * Purpose: Handles delta morph based animations.
 *
 ****************************************************************************/

#include "rwcore.h"
#include "rpworld.h"

#include "rpdmorph.h"

#include "skeleton.h"
#include "menu.h"

#include "clmpview.h"
#include "clmpdmrf.h"

RwBool ClumpHasDMorphData = FALSE;

static RpDMorphAnimation   *DMorphAnimation = NULL;
static RwBool               DMorphMenuActive = FALSE;
static RwReal               DMorphPerSecond = 1.0f;

/*
 *****************************************************************************
 */
static RpAtomic *
DMorphGetGeometry(RpAtomic *atomic, void *data)
{
    RpGeometry	*geom = RpAtomicGetGeometry(atomic);

    if (geom)
	{
	    *(RpGeometry **)(data) = geom;
	}

    return NULL;	// there should only be one atomic
}

static RpAtomic *
DMorphAtomicQueryData(RpAtomic *atomic, void *data)
{
    RwBool      *hasDMorphData = (RwBool *) data;
    RpGeometry	*geom = RpAtomicGetGeometry(atomic);

    if (geom && (RpDMorphGeometryGetNumDMorphTargets(geom) > 0) )
    {
        /* Found DMorph data - terminate iteration */
        *hasDMorphData = TRUE;
        return NULL;
    }
    
    return atomic;
}

/*
 *****************************************************************************
 */
RpAtomic* loopDMorphCallBack (RpAtomic* pAtom, void* pData)
{
  //## begin RWCharacterAnimator::loopDMorphCallBack%3B2539F600A2.body preserve=yes

//	RpDMorphAtomicSetAnimation(pAtom, DMorphAnimation);
	
	return pAtom;

  //## end RWCharacterAnimator::loopDMorphCallBack%3B2539F600A2.body
}
 
static RpAtomic *
DMorphAtomicSetAnimation(RpAtomic *atomic, void *data)
{
	int i;

	RwReal deltaTime;	

    RpGeometry	*geom = RpAtomicGetGeometry(atomic);

    if( geom && (RpDMorphGeometryGetNumDMorphTargets(geom) > 0) )
    {
        RpDMorphAtomicSetAnimation(atomic, DMorphAnimation);
//		deltaTime = 0.0f;	
//		RpDMorphAtomicAddTime(atomic, deltaTime);

		// ms
		
		i = RpDMorphGeometryGetNumDMorphTargets(geom);

    }

	RpDMorphAtomicSetAnimLoopCallBack(atomic, loopDMorphCallBack, NULL);
    
    return atomic;
}

/*
 *****************************************************************************
 */
static RpAtomic *
DMorphAtomicAddTime(RpAtomic *atomic, void *data)
{
    RwReal deltaTime = *(RwReal *)data;

    RpDMorphAtomicAddTime(atomic, deltaTime);

    return atomic;
}


/*
 *****************************************************************************
 */
static RwBool
DMorphPerSecondCB(RwBool justCheck)
{
    return (DMorphAnimation != NULL);
}
 
/*
 *****************************************************************************
 */
static void
DMorphMenuSetup(void)
{
    static RwChar DMorphPerSecondLabel[] = RWSTRING("DMorph Anim Speed");

    if( !DMorphMenuActive )
    {
        MenuAddEntryReal(DMorphPerSecondLabel,
                         &DMorphPerSecond,
                         DMorphPerSecondCB, 0.0f, 10.0f, 0.1f);

        DMorphMenuActive = TRUE;
    }
    
    return;
}


/*
 *****************************************************************************
 */
static void
DMorphMenuDestroy(void)
{
    MenuRemoveEntry(&DMorphPerSecond);

    DMorphMenuActive = FALSE;
    
    return;
}

/*
 *****************************************************************************
 */
RwBool 
DMorphLoadDMA(RpClump *clump, RwChar *dmaPath)
{
    if (ClumpHasDMorphData)
    {
        RwChar              *pathName;

        /*
         * Destroy any existing animation 
         */

#if 0
        if (DMorphAnimation)
        {
            RpDMorphAnimationDestroy(DMorphAnimation);
            DMorphAnimation = (RpDMorphAnimation *)NULL;
        }

        /*
         * Read the delta morph animation file... 
         */
        pathName = RsPathnameCreate(dmaPath);
        DMorphAnimation = RpDMorphAnimationRead(pathName);
        RsPathnameDestroy(pathName);
#endif

        if (DMorphAnimation)
        {
            RpClumpForAllAtomics(clump, DMorphAtomicSetAnimation, NULL);
        }
    }

    return (DMorphAnimation != NULL);
}


/*
 *****************************************************************************
 */
#define RPDMORPHGEOMETRYGETVERTICES(geometry)                       \
    ((geometry)->morphTarget->verts)

#define RPDMORPHGEOMETRYGETNORMALS(geometry)                        \
    ((geometry)->morphTarget->normals)

#define RPDMORPHGEOMETRYGETPRELIGHTCOLORS(geometry)                 \
    ((geometry)->preLitLum)

#define RPDMORPHGEOMETRYGETTEXCOORDS(geometry)                      \
    ((geometry)->texCoords[0])

#define RPDMORPHGEOMETRYGETBOUNDINGSPHERE(geometry)                 \
    ((geometry)->morphTarget->boundingSphere)

#define RPDMORPHGEOMETRYGETNUMBEROFVERTICES(geometry)               \
    ((geometry)->numVertices)

extern RpClump * ClumpUVTarget;

#define NUMBER_OF_KEYFRAMES 10

RwBool 
DMorphClumpInitialize(RpClump * clump, RwChar * clumpFileName)
{
	// create the DMorph Targets manually
#if 1
	RpGeometry * BaseGeometry; 
	RpGeometry * TargetGeometry; 
	RpGeometry * BaseGeometryBool; 
	RpGeometry * AddMorphBool; 
	RpDMorphAnimation * dMorphAnimation;
	RpDMorphAnimation * dMorphAnimationBool;
	int bsFlags = 0;
	RwTexCoords * targetTexCoords;
    RwV3d       *targetVertices;
	RpDMorphTarget * target;
	RpDMorphTarget * targetBool;
	RwChar * targetName = "dillthorp";
	int key;

	RwReal lastvalue;
	RwReal lasttime;
	RwReal time;
	RwReal value;
	RwBool returnVal;


    RpClumpForAllAtomics(clump, DMorphGetGeometry, &BaseGeometry);
    RpClumpForAllAtomics(ClumpUVTarget, DMorphGetGeometry, &TargetGeometry);

	BaseGeometryBool = RpDMorphGeometryCreateDMorphTargets(BaseGeometry, 1);

	dMorphAnimation = RpDMorphAnimationCreate(1);

//	bsFlags = rpGEOMETRYTEXTURED | rpGEOMETRYPOSITIONS;
	bsFlags = rpGEOMETRYTEXTURED;
    targetTexCoords = RPDMORPHGEOMETRYGETTEXCOORDS(TargetGeometry);
	targetVertices  = RPDMORPHGEOMETRYGETVERTICES(TargetGeometry);

//	AddMorphBool = RpDMorphGeometryAddDMorphTarget(BaseGeometry, 0, targetVertices, NULL, NULL, targetTexCoords, (RpGeometryFlag)bsFlags);
	AddMorphBool = RpDMorphGeometryAddDMorphTarget(BaseGeometry, 0, NULL, NULL, NULL, targetTexCoords, (RpGeometryFlag)bsFlags);

	target = RpDMorphGeometryGetDMorphTarget(BaseGeometry, 0);

	targetBool = RpDMorphTargetSetName(target, (char *)targetName);

	dMorphAnimationBool = RpDMorphAnimationCreateFrames(dMorphAnimation, 0, NUMBER_OF_KEYFRAMES);


	value = 0.0f;
	time = 0.0f;
	lastvalue = 0.0f;
	lasttime = 0.0f;

	for (key = 0 ; key < NUMBER_OF_KEYFRAMES ; key++)
	{
//yyy		time  += 0.1f;
//yyy		value += 0.1f;

		if (key > 0)
		{

			if ( key == (NUMBER_OF_KEYFRAMES - 1))
			{
//				dMorphAnimationBool = RpDMorphAnimationFrameSet(dMorphAnimation, 0, (key - 1), lastvalue, value, time - lasttime, 0);
				dMorphAnimationBool = RpDMorphAnimationFrameSet(dMorphAnimation, 0, (key - 1), lastvalue, value, time - lasttime, 0);
			}
			else
			{
//				dMorphAnimationBool = RpDMorphAnimationFrameSet(dMorphAnimation, 0, (key - 1), lastvalue, value, time - lasttime, key);
				dMorphAnimationBool = RpDMorphAnimationFrameSet(dMorphAnimation, 0, (key - 1), lastvalue, value, time - lasttime, key);
			}

		}

		lastvalue = value;
		lasttime = time;

//		time  += 0.01f;
//		value += 0.01f;
		time  += 1.0f / ((float)(NUMBER_OF_KEYFRAMES-1));
		value += 1.0f / ((float)(NUMBER_OF_KEYFRAMES-1));
	}

	DMorphAnimation = dMorphAnimation; 

	// nuke the target clump

	returnVal = RpClumpDestroy (ClumpUVTarget);


#endif
	//

    RpClumpForAllAtomics(clump, DMorphAtomicQueryData, &ClumpHasDMorphData);

    if (ClumpHasDMorphData)
    {
        RwChar *dmaFileName = (RwChar *) NULL;

        /*
         * Try to load <clumpName>.dma delta morph animation file...
         */
        dmaFileName = (RwChar *) RwMalloc(sizeof(RwChar) * 
                     (rwstrlen(clumpFileName) + 1));

        rwstrcpy(dmaFileName, clumpFileName);
        dmaFileName[rwstrlen(dmaFileName) - 3] = 0;
        rwstrcat(dmaFileName, RWSTRING("dma"));

        DMorphLoadDMA(clump, dmaFileName);

        RwFree(dmaFileName);

        DMorphMenuSetup();
    }
    else
    {
        DMorphMenuDestroy();
    }

    return ClumpHasDMorphData;
}

/*
 *****************************************************************************
 */
extern unsigned int pauseFlag;
extern unsigned int singleStep;

void
DMorphClumpUpdate( RwReal delta )
{
//	return;

	if ((pauseFlag == 1) || (singleStep == 1))	// added my ms
	{
	    if( ClumpHasDMorphData && DMorphAnimation && (delta > 0.0f))
	    {
	        delta *= DMorphPerSecond;
//	        delta = 0.033f;

			RpClumpForAllAtomics(Clump, DMorphAtomicAddTime, &delta);
	    }
	}

    return;
}

/*
 *****************************************************************************
 */
void 
DMorphDestroy()
{
    if (DMorphAnimation)
    {
       RpDMorphAnimationDestroy(DMorphAnimation);

       DMorphAnimation = NULL;
    }

    ClumpHasDMorphData = FALSE;

    return;
}