#ifndef MATPUTIL_H
#define MATPUTIL_H

#include <rwcore.h>

#include "baclump.h"
#include "bageomet.h"
#include "skyisms.h"

/* RWPUBLIC */

#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */

#define RWPS2RESHEADERFROMRESENTRY(resEntry) \
    ((rwPS2ResEntryHeader *)(resEntry + 1))

#if ( defined(RWDEBUG) || defined(RWSUPPRESSINLINE) )

extern RwMeshCache *
rpGeometryGetMeshCache(RpGeometry *geometry,
                       RwUInt32 numMeshes);

extern RwMeshCache *
rpAtomicGetMeshCache(RpAtomic *atomic,
                     RwUInt32 numMeshes);

extern RwMeshCache *
rpWorldSectorGetMeshCache(RpWorldSector *worldSector,
                          RwUInt32 numMeshes);

extern RwResEntry **
rwMeshCacheGetEntryRef(const RwMeshCache * meshCache,
                       RwUInt32 meshIndex);

#endif /* ( defined(RWDEBUG) || defined(RWSUPPRESSINLINE) ) */

extern void 
rpObjectDestroyMeshCache(RwMeshCache *meshCache);

extern RwMeshCache **
rpObjectGetMeshCache(RwMeshCache **meshCacheRef,
                     RwUInt32 numMeshes);

#ifdef    __cplusplus
}
#endif /* __cplusplus */


#if (! (defined(RWDEBUG) || defined(RWSUPPRESSINLINE)) )

#define rpGeometryGetMeshCache(_geometry, _numMeshes) \
    (*rpObjectGetMeshCache(&RWMESHCACHEFROMGEOMETRY(_geometry), _numMeshes))

#define rpAtomicGetMeshCache(_atomic, _numMeshes) \
    (*rpObjectGetMeshCache(&RWMESHCACHEFROMATOMIC(_atomic), _numMeshes))

#define rpWorldSectorGetMeshCache(_sector, _numMeshes) \
    (*rpObjectGetMeshCache(&RWMESHCACHEFROMWORLDSECTOR(_sector), _numMeshes))

#define rwMeshCacheGetEntryRef(_cache, _index) (&(_cache)->meshes[_index])

#endif /* (! (defined(RWDEBUG) || defined(RWSUPPRESSINLINE)) ) */

/* RWPUBLICEND */


#endif /* MATPUTIL_H */
