/*
 * Functionality for 2D rendering
 *
 * Copyright (c) 1998 Criterion Software Ltd.
 */

/**
 * \ingroup rt2d
 * \page rt2doverview Rt2d Toolkit Overview
 *
 * The Rt2d Toolkit provides a suite of powerful functions and datatypes
 * to assist in the programming of 2D graphics.
 *
 * The facilities include advanced font handling; textured and colored
 * brushes; fills; full support for outline and filled paths, as well as
 * an assortment of utility functions.
 */

/**
 * \ingroup rt2d
 * \page rt2dfontformat Rt2d Font Format
 *
 * The Rt2d Toolkit supports three font formats, one outline and two
 * bitmap fonts. Each font description is contained in a text file with .met
 * extension.
 *
 * \par Metric 1
 *
 * Metric 1 is a bitmap font and requires a bitmap image. An optional
 * mask can be specified after the image file.
 *
 * Metrics 1 uses the .met file to provide the characters available and their
 * dimension. The position values are the pixel co-ordinates in the image.
 *
 * The format of a metric 1 file is as follows,
 * \verbatim
       METRICS1
       <font bitmap> [<font mask bitmap>]
       <base line>
       <character code> <left pos> <top pos> <right pos> <bot pos>
       <character code> <left pos> <top pos> <right pos> <bot pos>
   \endverbatim
 * \par Metric 2
 *
 * Metric 2 is also a bitmap requiring a bitmap image. An optional mask
 * can be specified after the image file.
 *
 * The metric 2 .met file only list the characters available in the bitmap. Each
 * character's dimension are encoded in the image font.
 *
 * Each character in the image is surrounded by a boundary. This marks the dimension
 * of the character's bitmap. The start of a character's bitmap is denoted by a
 * marker pixel at the top left of each boundary. It is therefore important that the
 * color values of the marker pixel and the boundary are not used elsewhere.
 * Otherwise the character will use an incorrect area of the bitmap for the character.
 *
 * Metric 2 also support multiple bitmaps for the font. The font can spread over more
 * than one bitmap. This can be used to break up a large image into smaller sections.
 * Or it can be used to support font that have a large number of characters, such as
 * Kanji.
 *
 * Up to four image bitmaps can be specified.
 *
 * The format of a metric 2 file is as follows,
 * \verbatim
       METRICS2
       <font bitmap> [<font mask bitmap>]
       <base line>
       <characters>
       [<font bitmap>] [<font mask bitmap>]
       [<base line>]
       [<characters>]
   \endverbatim
 * \par Metric 3
 *
 * Metric 3 is an outline font similar to Adobe Type 1 fonts. Each character uses a
 * series of 2d vector commands to describe the geometric shape of the character.
 *
 * Each font character begins with the character string. The geometric description
 * begins with the begin keyword and ends with end keyword. There is no limit to
 * number of 2d commands for the font. A final moveto command is used to set the width
 * of the character.
 *
 * The format of a metric 3 file is as follows,
 * \verbatim
       METRICS3
       <font name>
       '<character>'
       begin
       moveto <x> <y>
       lineto <x> <y>
       curveto <x0> <y0> <x1> <y1> <x2> <y2>
       closepath
       moveto <x> <y>
       end
   \endverbatim
 */


#include <stdlib.h>
#include <math.h>
#include <string.h>

#include <rwcore.h>

#include <rpdbgerr.h>
#include "rt2d.h"

static const char   rcsid[] __RWUNUSED__ =
    "@@(#)$Id: rt2d.c,v 1.15 2001/07/04 09:28:40 katherinet Exp Colinh $";
