
/***************************************************************************
 *                                                                         *
 * Module  : baimform.h                                                    *
 *                                                                         *
 * Purpose : Handling different image formats                              *
 *                                                                         *
 **************************************************************************/

#ifndef RWIMFORM_H
#define RWIMFORM_H

/****************************************************************************
 Includes
 */

#include "batypes.h"
#include "baimage.h"

#if !(rwLIBRARYCURRENTVERSION > 0x310)
/*
 * See the comment in baimform.c, or contact jamesa@csl.com
 */

/****************************************************************************
 Defines
 */

#define C_WIN   1
#define C_OS2   2

#define rwImageGetWidth(_image) ((_image)->width)
#define rwImageGetHeight(_image) ((_image)->height)
#define rwImageGetDepth(_image) ((_image)->depth)
#define rwImageGetStride(_image) ((_image)->stride)
#define rwImageGetPalette(_image) ((_image)->palette)
#define rwImageGetPixels(_image) ((_image)->cpPixels)
#define rwImageGetPixel(_image, _x, _y)                                   \
  ( ( 32 == rwImageGetDepth(_image) ) ?                                   \
    ((RwRGBA *) & ((rwImageGetPixels(_image))                             \
                   [rwImageGetStride(_image) * (_y) + 4 * (_x)])):        \
    ( ( ( 8 == rwImageGetDepth(_image) ) || ( 4 == rwImageGetDepth(_image) ) ) ? \
      ( &((rwImageGetPalette(_image))                                     \
          [((RwInt32)((rwImageGetPixels(_image))                          \
                      [rwImageGetStride(_image) * (_y) + (_x)]))]) ) :    \
      NULL))

/****************************************************************************
 Global Types
 */

typedef RwUInt8     RwPixel24[3];

/* RWPUBLIC */

/****************************************************************************
 Function prototypes
 */

#ifdef    __cplusplus
extern              "C"
{
#endif                          /* __cplusplus */

extern RwImage     *RwImageReadBMP(const RwChar * imageName);
extern RwImage     *RwImageReadRAS(const RwChar * imageName);
extern RwImage     *RwImageWriteRAS(RwImage * image,
                                    const RwChar * imageName);
extern RwImage     *RwImageWriteBMP(RwImage * image,
                                    const RwChar * imageName);

#ifdef    __cplusplus
}
#endif                          /* __cplusplus */

/* RWPUBLICEND */

#endif /* !(rwLIBRARYCURRENTVERSION > 0x310) */

#endif                          /* RWINFORM_H */
