#ifndef _PRVPRTCL_H
#define _PRVPRTCL_H

enum RpParticlesFlag
{
    rpPARTICLESDIRTY        = 0x01,
    rpPARTICLESSETBSPHERE   = 0x02
};
typedef enum RpParticlesFlag RpParticlesFlag;

typedef struct RpParticlesData RpParticlesData;
struct RpParticlesData
{
    RwInt32 numParticles;
    RwReal flightTime;
    RwReal duration;
    RwReal time;
    RwV2d particleSize;
    RwV2d emitterSize;
    RwReal speed;
    RwReal speedVariation;
    RwReal randomSeed;
    RwReal dampening;
    RwReal angle;
    RwReal growth;
    RwV3d force;
    RwRGBAReal startCol;
    RwRGBAReal endCol;
    RpParticlesFlag flags;
};

#define MESSAGE(_string) RwDebugSendMessage(rwDEBUGMESSAGE, "prtcl", _string)

#define PARTICLESATOMICGETDATA(atomic)  \
    ((RpParticlesData **)(((RwUInt8 *)atomic) + GParticlesAtomicDataOffset))

#define PARTICLESATOMICGETCONSTDATA(atomic)   \
    ((const RpParticlesData **)(((const RwUInt8 *)atomic) + GParticlesAtomicDataOffset))


extern RxPipeline *GParticlesInstancePipe;
extern RxPipeline *GParticlesRenderPipe;
extern RwInt32 GParticlesAtomicDataOffset;

#endif /* _PRVPRTCL_H */
