/*
 * Skin plug-in
 */

/****************************************************************************
 *                                                                          *
 *  Module  :   SkinBumpPipe.c                                               *
 *                                                                          *
 *  Purpose :   Skin Bump mapping pipeline for PS2                          *
 *                                                                          *
 ****************************************************************************/

/****************************************************************************
 Includes
 */
#include <rpdbgerr.h>
#include <rpmatfx.h>
#include <rpskin.h>

#include "../../driver/sky2/baasm.h"

#include "rpplugin.h"
#include "effectPipes.h"
#include "effectPipesSky.h"

#include "../skinpp/skinpriv.h"
#include "../skinpp/matblend.h"

#include "SKY2_SkinBumpMapping/stddata.h"
#include "SKY2_SkinBumpMapping/skinBumpPipe.h"

/*----------------------------------------------------------------------*/
/*-                                Definition                          -*/
/*----------------------------------------------------------------------*/
matFXVUcode RWALIGN(skySkinBumpMapTransforms, rpMATFXALIGNMENT) =
{
    &SkinBumpMappingPRS, &vu1nullTrans,
    &SkinBumpMappingPRL, &vu1nullTrans,
    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans
};

/*==========================================================================*/
/*                                                                          */
/*                               Functions                                  */
/*                                                                          */
/*==========================================================================*/
extern RwBool
_rpMatFXSkinBumpInstanceCallBack( void **clusterData,
                                  RwUInt32 __RWUNUSED__ numClusters )
{
    /* --------------- Pipe --------------------------------------*/
    RxPS2Mesh *mesh = (RxPS2Mesh *)clusterData[0];
    RxPS2DMASessionRecord *dmaSessionRec =
        (RxPS2DMASessionRecord *)clusterData[1];
    rpMatFXMaterialData *materialData =
        (rpMatFXMaterialData *)*MATFXMATERIALGETDATA(mesh->mesh->material);
    /* --------------- Skin --------------------------------------*/
    RpAtomic  *atomic     = dmaSessionRec->sourceObject.atomic;
    RpSkin    *pSkin      = *MATFXSKINATOMICGETDATA(atomic);
    RwUInt32  numMatrices = pSkin->numBones;
    RwReal    *destMBI    = (RwReal *)(clusterData[2]);
    RwInt32   DMAstorage  = 0;
    RwMatrix  *pMBA       = (RwMatrix *)NULL;
    /*---------------- Bump --------------------------------------*/
    RwReal    bumpCoef;
    RwTexture *texture;

    RWFUNCTION(RWSTRING("_rpMatFXSkinBumpInstanceCallBack"));
    RWASSERT(NULL != mesh);
    RWASSERT(NULL != dmaSessionRec);
    RWASSERT(NULL != destMBI);
    RWASSERT(NULL != atomic);
    RWASSERT(NULL != pSkin);
    RWASSERT(NULL != pSkin->pCurrentHierarchy);

    bumpCoef = materialData->data[rpSECONDPASS].data.bumpMap.coef *
        materialData->data[rpSECONDPASS].data.bumpMap.invBumpWidth;

    texture = materialData->data[rpSECONDPASS].data.bumpMap.texture;
    RWASSERT(texture);

    /* Do we have a bumpMap texture? */
    if (NULL == texture)
    {
        /* No - then lets borrow the material one. */
        texture = mesh->mesh->material->texture;
    }

    /*------------ Skin weights and indices instancing -----------*/
    if (dmaSessionRec->serialNum != ((RwUInt32 *) (*(mesh->cacheEntryRef) + 1))[3])
    {
        matFXSkinning.skinMBWeightsInstancing(mesh->mesh, pSkin, destMBI);
    }

    /*----------------- Bones matrices uploading -----------------*/
    if (matFXSkinning.skinAtomicGlobals->SkinMatrixCacheSkin != pSkin ||
        matFXSkinning.skinAtomicGlobals->SkinMatrixCacheRenderFrame != RWSRCGLOBAL(renderFrame))
    {
        pMBA           = matFXSkinning.skinMBMatUpdating(atomic, pSkin);
        RWASSERT(NULL != pMBA);
        DMAstorage     = numMatrices * 4;
    }

    /*----------------- DMA data Upload --------------------------*/
    {
        /* RwUInt64            prim         = 0x0l; */
        u_long128           ltmp        = 0;
        RwUInt64            tmp, tmp1;

        /*---------------- DMA packet -----------------------*/
        sweFinaliseOpenLocalPkt(SWE_LPS_NOFIXUP |
                                SWE_PKT_DMA_MODE_CHAIN_TTE |
                                SWE_PKT_LOCAL | SWE_PKT_VU1 |
                                SWE_PKT_CIRCALLOC,
                                -(12 + DMAstorage));
        if (!sweLocalPacket)
        {
            RWRETURN(FALSE);
        }
        tmp  = ((1l << 28) | (DMAstorage + 10));
        tmp1 = ((((0x6cl << 24)               |
               ((DMAstorage + 10) << 16)      |
               ((long) (pipeASymbSkinStaticBumpDataStart))) << 32) |
               ((1l << 24) | (4 << 8) | (4)));
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);
        /*---------------------------------------------------*/

        /*------------------ Emboss Bump Data --------------*/
        tmp  = (*(const RwUInt32 *) &bumpCoef);
        tmp1 = (*(const RwUInt32 *) &matFXBumpFarPlane);
        tmp1 = ((tmp1 << 32) | (*(const RwUInt32 *) &matFXBumpScale));
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);

        /*------------------ Bump CTX1 Bump Tag2 ------------*/
        /* First pass bump map tag modifyer */
        tmp = /* NLOOP */ 2l
            | /* EOP   */ (1l << 15)
            | /* PRE   */ (0l << 46)
            | /* FLG   */ (0l << 58)
            | /* NREG  */ (1l << 60);
        tmp1 =/* A+D   */ (0xel << (64 - 64));
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);
        MAKE128(ltmp, GS_ALPHA_1, 0x8000000002l);
        SWEADDCONTFAST(ltmp);
        MAKE128(ltmp, GS_TEST_1, 0x50002l);
        SWEADDCONTFAST(ltmp);

        /*------------------ Bump CTX1 Bump Tag1 ------------*/
        tmp = /* NLOOP */ 2l
            | /* EOP   */ (1l << 15)
            | /* PRE   */ (0l << 46)
            | /* FLG   */ (0l << 58)
            | /* NREG  */ (1l << 60);
        tmp1 =/* A+D   */ (0xel << (64 - 64));
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);
        MAKE128(ltmp, GS_ALPHA_1, 0x8000000048l);
        SWEADDCONTFAST(ltmp);
        MAKE128(ltmp, GS_TEST_1, 0x50002l);
        SWEADDCONTFAST(ltmp);

        /*------------ Bump Map matrix ----------------------*/
        ltmp = *((u_long128 *) & (matFXBumpMatrix.right));
        SWEADDCONTFAST(ltmp);
        ltmp = *((u_long128 *) & (matFXBumpMatrix.up));
        SWEADDCONTFAST(ltmp);
        ltmp = *((u_long128 *) & (matFXBumpMatrix.at));
        SWEADDCONTFAST(ltmp);

        /*-------- Upload Skin matrices ---------------------*/
        if(DMAstorage)
        {
            RwUInt32  i;
            for (i = 0; i < numMatrices; i++)
            {
                ltmp = *((u_long128 *) & pMBA->right.x);
                SWEADDCONTFAST(ltmp);
                ltmp = *((u_long128 *) & pMBA->up.x);
                SWEADDCONTFAST(ltmp);
                ltmp = *((u_long128 *) & pMBA->at.x);
                SWEADDCONTFAST(ltmp);
                ltmp = *((u_long128 *) & pMBA->pos.x);
                SWEADDCONTFAST(ltmp);
                pMBA++;
            }
        }

        /*------- Terminate the DMA with an interrupt -------*/
        tmp = (0xfl << 28);
        MAKE128(ltmp, 0l, tmp);
        SWEADDCONTFAST(ltmp);
        /*---------------------------------------------------*/

        sweFinaliseOpenLocalPkt(SWE_LPS_CONT, 0);
    }

    /*---- Stealth function ----*/

    /* Lets upload the bumpMap texture. */
    _rpMatFXUploadTexture(texture, dmaSessionRec, mesh);

    RWRETURN(TRUE);
}
