/**
 * Xbox Anisotropic Texture Sampling Plugin for RenderWare.
 */

#ifndef RPANISOTPLUGIN_H
#define RPANISOTPLUGIN_H

/**
 * \defgroup rpanisot RpAnisot
 * \ingroup rpplugin
 *
 * Xbox Anisotropic Texture Sampling Plugin for RenderWare.
 */

#include <rwcore.h>

#ifdef __cplusplus
extern              "C"
{
#endif

extern RwInt8      RpAnisotGetMaxSupportedMaxAnisotropy(void);

extern RwTexture    *RpAnisotTextureSetMaxAnisotropy(RwTexture *tex, RwInt8 val);
extern RwInt8       RpAnisotTextureGetMaxAnisotropy(RwTexture *tex);

extern RwBool       RpAnisotPluginAttach(void);

#ifdef __cplusplus
}
#endif

#endif                          /* RPANISOTPLUGIN_H */
