
/****************************************************************************
 *
 * VRML 2.0 to RW3.0 Converter
 * Copyright (C) 1997 Criterion Technologies
 *
 * Author  : Damian Scallan 
 *
 * Module  : VrmlNodeType.c
 *                                                                         
 * Purpose : The VrmlNodeType class is responsible for storing the field type 
 *           & value information of standard & user defined prototypes,
 *
 ****************************************************************************/

#ifndef VRMLNODETYPE_H
#define VRMLNODETYPE_H

/****************************************************************************
 Includes
 */

#include "_rpvrml.h"
#include "llinklist.h"
#include "types.h"
#include "abstractnode.h"

/****************************************************************************
 Global Types
 */

#if (0)
typedef struct NameTypeRec NameTypeRec;
struct NameTypeRec
{
    char *name;
    int type;
};



#endif /* (0) */

typedef AbstractField NameTypeRec;

typedef struct VrmlNodeType VrmlNodeType;
struct VrmlNodeType
{              /* used to store Proto Node info */
    char *name;
    VRMLBool userProto;
    AbstractField *afUrl;
    LLinkList fields; /* of AbstractField */
    LLinkList eventIns; /* of AbstractField */
    LLinkList eventOuts; /* of AbstractField */
    LLinkList aNodeDefs; /* of AbstractNode */
};



typedef void (*Vrml_addCB) (VrmlNodeType * t, const char *name,
                            int type);

/****************************************************************************
 Function prototypes
 */

#ifdef    __cplusplus
extern "C"
{
#endif         /* __cplusplus */

RwBool VrmlNodeTypeOpen(void);
void VrmlNodeTypeClose(void);

VrmlNodeType *VrmlNodeType_Create(const char *nm);

/* Destructor exists mainly to deallocate storage for name */
RwBool VrmlNodeType_Destroy(VrmlNodeType *);

/* Routines for adding/getting eventIns/Outs/fields */
RwBool VrmlNodeType_addEventIn(VrmlNodeType *, const char
                               *name, int type);
RwBool VrmlNodeType_addEventOut(VrmlNodeType *, const char
                                *name, int type);
RwBool VrmlNodeType_addField(VrmlNodeType *, const char
                             *name, int type);
RwBool VrmlNodeType_addExposedField(VrmlNodeType *, const char
                                    *name, int type);
RwInt32 VrmlNodeType_hasEventIn(VrmlNodeType *, const char *name);
RwInt32 VrmlNodeType_hasEventOut(VrmlNodeType *, const char *name);
RwInt32 VrmlNodeType_hasField(VrmlNodeType *, const char *name);
RwInt32 VrmlNodeType_hasExposedField(VrmlNodeType *,
                                     const char *name);
const char *VrmlNodeType_getName(VrmlNodeType *);
AbstractNode *VrmlNodeType_GetBaseAbstractNode(VrmlNodeType *
                                               _type);

/*
 *  Namespace management functions.  PROTO definitions add node types
 *  to the namespace.  PROTO implementations are a separate node
 *  namespace, and require that any nested PROTOs NOT be available
 *  outside the PROTO implementation.
 *  addToNameSpace will print an error to stderr if the given type
 *  is already defined.
*/
void TypeList_Init(void);
void TypeList_Destroy(void);
RwBool TypeList_addToNameSpace(VrmlNodeType *);
RwBool TypeList_pushNameSpace(void);
RwBool TypeList_popNameSpace(void);

/* Find a node type, given its name.  Returns NULL if type is not defined. */
VrmlNodeType *TypeList_find(const char *nm);

#ifdef    __cplusplus
}
#endif         /* __cplusplus */

#endif         /* VRMLNODETYPE_H */
