/*
 *
 * VRML to RW converter plug-in
 */
#include "rpplugin.h"
#include "animfuncttab.h"
#include "rpvrmlanim.h"
#include "rpvrml.h"

static const char __RWUNUSED__ rcsid[] =
    "@@(#)$Id: vrmlanimopen.c,v 1.21 2001/01/26 12:11:05 johns Exp $";

static void
_setupAnimFunctions(void)
{
    RpVRMLAnimFunctions *animFunctions;

    RWFUNCTION(RWSTRING("_setupAnimFunctions"));

    _rpVrmAnimFunctionsOpen();
    animFunctions = _rpVrmAnimFunctionsGet();

    animFunctions->fpFrameAnimSetTranslations =
        _rpVrmlFrameAnimSetTranslations;
    animFunctions->fpFrameAnimSetRotations =
        _rpVrmlFrameAnimSetRotations;
    animFunctions->fpFrameAnimSetScales = _rpVrmlFrameAnimSetScales;
    animFunctions->fpFrameAnimSetScaleOrients =
        _rpVrmlFrameAnimSetScaleOrients;
    animFunctions->fpAnimRotateCreate = _rpVrmAnimRotateCreate;
    animFunctions->fpAnimRotateDestroy = _rpVrmAnimRotateDestroy;
    animFunctions->fpAnimRotateAddKeys = _rpVrmAnimRotateAddKeys;
    animFunctions->fpAnimRotateGetKeys = _rpVrmAnimRotateGetKeys;
    animFunctions->fpAnimRotateSetController = _rpVrmAnimRotateSetState;
    animFunctions->fpAnimTranslateCreate = _rpVrmAnimTranslateCreate;
    animFunctions->fpAnimTranslateDestroy = _rpVrmAnimTranslateDestroy;
    animFunctions->fpAnimTranslateAddKeys = _rpVrmAnimTranslateAddKeys;
    animFunctions->fpAnimTranslateGetKeys = _rpVrmAnimTranslateGetKeys;
    animFunctions->fpAnimTranslateSetController =
        _rpVrmAnimTranslateSetState;
    animFunctions->fpAnimScaleCreate = _rpVrmAnimScaleCreate;
    animFunctions->fpAnimScaleDestroy = _rpVrmAnimScaleDestroy;
    animFunctions->fpAnimScaleAddKeys = _rpVrmAnimScaleAddKeys;
    animFunctions->fpAnimScaleGetKeys = _rpVrmAnimScaleGetKeys;
    animFunctions->fpAnimScaleSetController = _rpVrmAnimScaleSetState;
    animFunctions->fpAnimControllerCreate = _rpVrmAnimStateCreate;
    animFunctions->fpAnimControllerAddInterpolator =
        _rpVrmAnimStateAddInterpolator;
    animFunctions->fpFrameAnimGetMatrixComp =
        _rpVrmlFrameAnimGetTransformState;
    animFunctions->fpFrameAnimSetName = _rpVrmlFrameAnimSetName;
    animFunctions->fpFrameAnimAddTime = _rpVrmlFrameAnimAddTime;

    RWRETURNVOID();

}

void               *
_rpVrmlAnimOpen(void *instance, RwInt32 offset, RwInt32 size)
{
    RWFUNCTION(RWSTRING("_rpVrmlAnimOpen"));
    RWASSERT(instance);

    if (instance)
    {
        _setupAnimFunctions();

        RWRETURN(_rpVrmlOpen(instance, offset, size));
    }

    RWERROR((E_RW_NULLP));
    RWRETURN(NULL);
}
