
/****************************************************************************
 *  
 * VRML 2.0 to RW3.0 Converter
 * Copyright (C) 1997 Criterion Technologies
 *
 * Author  : Damian Scallan 
 *
 * Module  : Symtable.h
 *                                                                         
 * Purpose : Used to implement Vrml DEF & USE 
 *          Places symbol in table along with its AbstractNode pointer
 *          for later instancing with USE
 *          
 ****************************************************************************/

#ifndef SYMBOLTABLE_H
#define SYMBOLTABLE_H

/****************************************************************************
 Includes
 */

#include "_rpvrml.h"
#include "abstractnode.h"

/****************************************************************************
 Function prototypes
 */

#ifdef    __cplusplus
extern          "C"
{
#endif         /* __cplusplus */

    void            SymTab_Create(void);
    void            SymTab_Destroy(void);
    RwBool          SymTab_AddEntry(const RwChar *name, AbstractNode *an);
    AbstractNode   *SymTab_GetEntry(const RwChar *name);

    RwBool          SymTab_ProtoInstance(void);

    RwBool          SymTab_AddRouteEntry(const RwChar *fromName, const RwChar *eventOutName, 
                                         const RwChar *toName, const RwChar *eventInName);
    RwBool          SymbolRouteEnt_Set(void);

#ifdef    __cplusplus
}
#endif         /* __cplusplus */

#endif         /* SYMBOLTABLE_H */
