
/****************************************************************************
 *
 * VRML 2.0 to RW3.0 Converter
 * Copyright (C) 1997 Criterion Technologies
 *
 * Author   : Damian Scallan
 *
 * Based on original parser code by Gavin Bell & 
 * Daniel Woods (first port) of Silicon Graphics, Inc.
 *
 ****************************************************************************/

#ifndef PARSER_H
#define PARSER_H

/****************************************************************************
 Includes
 */

#include "_rpvrml.h"
#include "builder.h"
#include "vrmlnodetype.h"
#include "llinklist.h"

/****************************************************************************
 Global Types
 */

/****************************************************************************
 Global Variables
 */

/****************************************************************************
 Function prototypes
 */

#ifdef    __cplusplus
extern          "C"
{
#endif         /* __cplusplus */

RwBool          ParserBegin(void);
RwBool          ParseFile(const RwChar *filename);
AbstractNode   *ParseInlineFile(const RwChar *url);
void            ParserEnd(void);

/* Some helper routines defined below: */
RwBool          beginProto(const char *protoName);
RwBool          endProto(void);
RwInt32         addField(const RwChar *type, const RwChar *name);
RwInt32         addEventIn(const RwChar *type, const RwChar *name);
RwInt32         addEventOut(const RwChar *type, const RwChar *name);
RwInt32         addExposedField(const RwChar *type, const RwChar *name);
RwInt32         add(Vrml_addCB, const RwChar *, const RwChar *);
RwInt32         fieldType(const RwChar *type);
RwBool          enterNode(const RwChar *nodeType);
AbstractNode   *exitNode(void);
RwBool          enterUse(const RwChar *name);
RwBool          enterScript(void);
void            exitScript(void);
RwBool          enterField(const char *);
void            exitField(void);
void            expect(RwInt32 type);
RwBool          DoConversion(LLinkList *anList);
RwBool          isSceneGraph(RwChar *name);

AbstractNode   *instanceClone(AbstractNode *anDef, AbstractNode *anProto, VrmlNodeType *t);
AbstractNode   *instanceUserProto(AbstractNode *an);
RwBool          instanceIs(const RwChar *name);

RwBool          enterProtoField(const char *name);
void            exitProtoField(void);
RwBool          enterExternProtoUrlField(const RwChar *name);
RwBool          exitExternProtoUrlField(void);

#ifdef    __cplusplus
}
#endif         /* __cplusplus */

#endif         /* PARSER_H */
