/*
 *
 * VRML to RW converter plug-in
 */

/****************************************************************************
 *    
 * VRML 2.0 to RW3.0 Converter
 * Copyright (C) 1997 Criterion Technologies
 *
 * Author  : Damian Scallan 
 *
 * Module  : NodeStubs.c
 *                                                                         
 * Purpose : Contains stubs for node conversion functions
 *          awaiting implementation
 *
 ****************************************************************************/

/****************************************************************************
 Includes
 */

#include <stdio.h>
#include <assert.h>
#include <string.h>

#include "rpplugin.h"
#include "nodestubs.h"

/* temp include for inline */
#include "parser.h"
#include "rpvrmlanim.h"
#include "rpvrml.h"
#include "converter.h"

static const char __RWUNUSED__ rcsid[] =
    "@@(#)$Id: nodestubs.c,v 1.23 2001/01/26 12:10:41 johns Exp $";

RwBool
AudioClip_Convert(AbstractNode * an)
{
    char               *nodeName;

    RWFUNCTION(RWSTRING("AudioClip_Convert"));
    RWASSERT(an);
    nodeName = AbstractNode_GetBaseName(an);
    /*RWASSERT(strcmp(nodeName, "AudioClip") == 0); */

    RWRETURN(TRUE);
}

RwBool
Background_Convert(AbstractNode * an)
{
    char               *nodeName;

    RWFUNCTION(RWSTRING("Background_Convert"));
    RWASSERT(an);
    nodeName = AbstractNode_GetBaseName(an);
    /*RWASSERT(strcmp(nodeName, "Background") == 0); */

    RWRETURN(TRUE);
}

RwBool
ColorInterpolator_Convert(AbstractNode * an)
{
    char               *nodeName;

    RWFUNCTION(RWSTRING("ColorInterpolator_Convert"));
    RWASSERT(an);
    nodeName = AbstractNode_GetBaseName(an);
    /*RWASSERT(strcmp(nodeName, "ColorInterpolator") == 0); */

    RWRETURN(TRUE);
}

RwBool
CoordinateInterpolator_Convert(AbstractNode * an)
{
    char               *nodeName;

    RWFUNCTION(RWSTRING("CoordinateInterpolator_Convert"));
    RWASSERT(an);
    nodeName = AbstractNode_GetBaseName(an);
    /*RWASSERT(strcmp(nodeName, "CoordinateInterpolator") == 0); */

    RWRETURN(TRUE);
}

RwBool
CylinderSensor_Convert(AbstractNode * an)
{
    char               *nodeName;

    RWFUNCTION(RWSTRING("CylinderSensor_Convert"));
    RWASSERT(an);
    nodeName = AbstractNode_GetBaseName(an);
    /*RWASSERT(strcmp(nodeName, "CylinderSensor") == 0); */

    RWRETURN(TRUE);
}

RwBool
Fog_Convert(AbstractNode * an)
{
    char               *nodeName;

    RWFUNCTION(RWSTRING("Fog_Convert"));
    RWASSERT(an);
    nodeName = AbstractNode_GetBaseName(an);
    /*RWASSERT(strcmp(nodeName, "Fog") == 0); */

    RWRETURN(TRUE);
}

RwBool
Inline_Convert(AbstractNode * an)
{
    char               *nodeName;
    AbstractNode       *anInline;
    AbstractField      *af;
    sfstring           *url;

    RWFUNCTION(RWSTRING("Inline_Convert"));
    RWASSERT(an);
    nodeName = AbstractNode_GetBaseName(an);
    /*RWASSERT(strcmp(nodeName, "Inline") == 0); */

    /* get the URL */
    if ((af = AbstractNode_GetAbstractField(an, "url")))
    {
        Field              *field;

        field = AbstractField_GetField(af);
        url = FieldSfstring_GetValue(field);

        /* get hold of abstract node list */
        if (url)
        {
            anInline = ParseInlineFile(*url);
            if (anInline)
            {
                /* now convert it */
                Convert_Children(anInline);

                RWRETURN(TRUE);
            }
        }
    }

    RWRETURN(FALSE);
}

RwBool
LOD_Convert(AbstractNode * an)
{
    char               *nodeName;

    RWFUNCTION(RWSTRING("LOD_Convert"));
    RWASSERT(an);
    nodeName = AbstractNode_GetBaseName(an);
    /*RWASSERT(strcmp(nodeName, "LOD") == 0); */

    RWRETURN(TRUE);
}

RwBool
NavigationInfo_Convert(AbstractNode * an)
{
    char               *nodeName;

    RWFUNCTION(RWSTRING("NavigationInfo_Convert"));
    RWASSERT(an);
    nodeName = AbstractNode_GetBaseName(an);
    /*RWASSERT(strcmp(nodeName, "NavigationInfo") == 0); */

    RWRETURN(TRUE);
}

RwBool
NormalInterpolator_Convert(AbstractNode * an)
{
    char               *nodeName;

    RWFUNCTION(RWSTRING("NormalInterpolator_Convert"));
    RWASSERT(an);
    nodeName = AbstractNode_GetBaseName(an);
    /*RWASSERT(strcmp(nodeName, "NormalInterpolator") == 0); */

    RWRETURN(TRUE);
}

RwBool
OrientationInterpolator_Convert(AbstractNode * an)
{
    char               *nodeName;

    RWFUNCTION(RWSTRING("OrientationInterpolator_Convert"));
    RWASSERT(an);
    nodeName = AbstractNode_GetBaseName(an);
    /*RWASSERT(strcmp(nodeName, "OrientationInterpolator") == 0); */

    RWRETURN(TRUE);
}

RwBool
PlaneSensor_Convert(AbstractNode * an)
{
    char               *nodeName;

    RWFUNCTION(RWSTRING("PlaneSensor_Convert"));
    RWASSERT(an);
    nodeName = AbstractNode_GetBaseName(an);
    /*RWASSERT(strcmp(nodeName, "PlaneSensor") == 0); */

    RWRETURN(TRUE);
}

RwBool
PositionInterpolator_Convert(AbstractNode * an)
{
    char               *nodeName;

    RWFUNCTION(RWSTRING("PositionInterpolator_Convert"));
    RWASSERT(an);
    nodeName = AbstractNode_GetBaseName(an);
    /*RWASSERT(strcmp(nodeName, "PositionInterpolator") == 0); */

    RWRETURN(TRUE);
}

RwBool
ProximitySensor_Convert(AbstractNode * an)
{
    char               *nodeName;

    RWFUNCTION(RWSTRING("ProximitySensor_Convert"));
    RWASSERT(an);
    nodeName = AbstractNode_GetBaseName(an);
    /*RWASSERT(strcmp(nodeName, "ProximitySensor") == 0); */

    RWRETURN(TRUE);
}

RwBool
ScalarInterpolator_Convert(AbstractNode * an)
{
    char               *nodeName;

    RWFUNCTION(RWSTRING("ScalarInterpolator_Convert"));
    RWASSERT(an);
    nodeName = AbstractNode_GetBaseName(an);
    /*RWASSERT(strcmp(nodeName, "ScalarInterpolator") == 0); */

    RWRETURN(TRUE);
}

RwBool
Script_Convert(AbstractNode * an)
{
    char               *nodeName;

    RWFUNCTION(RWSTRING("Script_Convert"));
    RWASSERT(an);
    nodeName = AbstractNode_GetBaseName(an);
    /*RWASSERT(strcmp(nodeName, "Script") == 0); */

    RWRETURN(TRUE);
}

RwBool
Sound_Convert(AbstractNode * an)
{
    char               *nodeName;

    RWFUNCTION(RWSTRING("Sound_Convert"));
    RWASSERT(an);
    nodeName = AbstractNode_GetBaseName(an);
    /*RWASSERT(strcmp(nodeName, "Sound") == 0); */

    RWRETURN(TRUE);
}

RwBool
SphereSensor_Convert(AbstractNode * an)
{
    char               *nodeName;

    RWFUNCTION(RWSTRING("SphereSensor_Convert"));
    RWASSERT(an);
    nodeName = AbstractNode_GetBaseName(an);
    /*RWASSERT(strcmp(nodeName, "SphereSensor") == 0); */

    RWRETURN(TRUE);
}

RwBool
Switch_Convert(AbstractNode * an)
{
    RWFUNCTION(RWSTRING("Switch_Convert"));
    RWASSERT(an);

    if (an)
    {
        char               *nodeName;

        nodeName = AbstractNode_GetBaseName(an);
        /*RWASSERT(strcmp(nodeName, "Switch") == 0); */

        RWERROR((E_RP_VRML_SWITCH, an->lineNum));

        RWRETURN(TRUE);
    }

    RWRETURN(FALSE);
}

RwBool
TimeSensor_Convert(AbstractNode * an)
{
    char               *nodeName;

    RWFUNCTION(RWSTRING("TimeSensor_Convert"));
    RWASSERT(an);
    nodeName = AbstractNode_GetBaseName(an);
    /*RWASSERT(strcmp(nodeName, "TimeSensor") == 0); */

    RWRETURN(TRUE);
}

RwBool
TouchSensor_Convert(AbstractNode * an)
{
    char               *nodeName;

    RWFUNCTION(RWSTRING("TouchSensor_Convert"));
    RWASSERT(an);
    nodeName = AbstractNode_GetBaseName(an);
    /*RWASSERT(strcmp(nodeName, "TouchSensor") == 0); */

    RWRETURN(TRUE);
}

RwBool
Viewpoint_Convert(AbstractNode * an)
{
    char               *nodeName;

    RWFUNCTION(RWSTRING("Viewpoint_Convert"));
    RWASSERT(an);
    nodeName = AbstractNode_GetBaseName(an);
    /*RWASSERT(strcmp(nodeName, "Viewpoint") == 0); */

    RWRETURN(TRUE);
}

RwBool
VisibilitySensor_Convert(AbstractNode * an)
{
    char               *nodeName;

    RWFUNCTION(RWSTRING("VisibilitySensor_Convert"));
    RWASSERT(an);
    nodeName = AbstractNode_GetBaseName(an);
    /*RWASSERT(strcmp(nodeName, "VisibilitySensor") == 0); */

    RWRETURN(TRUE);
}

RwBool
WorldInfo_Convert(AbstractNode * an)
{
    char               *nodeName;

    RWFUNCTION(RWSTRING("WorldInfo_Convert"));
    RWASSERT(an);
    nodeName = AbstractNode_GetBaseName(an);
    /*RWASSERT(strcmp(nodeName, "WorldInfo") == 0); */

    RWRETURN(TRUE);
}
