
/****************************************************************************
 * 
 * VRML 2.0 to RW3.0 Converter
 * Copyright (C) 1997 Criterion Technologies
 *
 * Author  : Damian Scallan 
 *
 * Module  : GroupNodes.c
 *                                                                         
 * Purpose : Converts the Group nodes :-
 * (Anchor, Billboard, Collision, Group, & Transform)
 *                                                                         
 ****************************************************************************/

#ifndef GROUPNODES_H
#define GROUPNODES_H

/****************************************************************************
 Includes
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>

#include "_rpvrml.h"
#include "abstractnode.h"

/****************************************************************************
 Function prototypes
 */

#ifdef    __cplusplus
extern          "C"
{
#endif         /* __cplusplus */

    RwBool          Anchor_Convert(AbstractNode * an);
    RwBool          Billboard_Convert(AbstractNode * an);
    RwBool          Collision_Convert(AbstractNode * an);
    RwBool          Group_Convert(AbstractNode * an);
    RwBool          Dummy_Convert(AbstractNode * an);
    RwBool          Transform_Convert(AbstractNode * an);
    sfvec3f        *Transform_GetOffset(void);
    void            Transform_ResetOffset(void);

#ifdef    __cplusplus
}
#endif         /* __cplusplus */

#endif  /* GROUPNODES_H */
