/*
 *
 * VRML to RW converter plug-in
 */

/****************************************************************************
 *
 * VRML 2.0 to RW3.0 Converter
 * Copyright (C) 1997 Criterion Technologies
 *
 * Author  : Damian Scallan 
 *
 * Module  : fieldrec.c
 *                                                                         
 * Purpose : Used to keep track of which field in which type of 
 *           node is being parsed. 
 *
 ****************************************************************************/

/****************************************************************************
 Includes
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include "rpplugin.h"
#include <rpdbgerr.h>
#include "rpvrmlanim.h"
#include "rpvrml.h"
#include "fieldrec.h"

static const char __RWUNUSED__ rcsid[] =
    "@@(#)$Id: fieldrec.c,v 1.18 2001/02/05 11:44:12 johns Exp $";

/****************************************************************************
 Local (static) Globals
 */

static RwFreeList  *fieldRecFreeList = (RwFreeList *)NULL;

/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   Initialisation/Termination

   !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */

RwBool
FieldRecOpen(void)
{
    RWFUNCTION(RWSTRING("FieldRecOpen"));

    fieldRecFreeList = RwFreeListCreate(sizeof(FieldRec), 20, 0);
    if (!fieldRecFreeList)
    {
        RWRETURN((FALSE));
    }

    RWRETURN((TRUE));
}

void
FieldRecClose(void)
{
    RWFUNCTION(RWSTRING("FieldRecClose"));

    if (fieldRecFreeList)
    {
        RwFreeListDestroy(fieldRecFreeList);
        fieldRecFreeList = (RwFreeList *)NULL;
    }
    RWRETURNVOID();
}

/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   VrmlNodeType methods

   !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */

FieldRec           *
FieldRec_Create(void)
{
    FieldRec           *fr;

    RWFUNCTION(RWSTRING("FieldRec_Create"));

    fr = (FieldRec *) RwFreeListAlloc(fieldRecFreeList);
    if (!fr)
    {
        RWRETURN(((FieldRec *)NULL));
    }

    fr->type = 0;
    fr->fieldName = (char *)NULL;
    fr->nodeType = (VrmlNodeType *)NULL;
    fr->abstractNode = (AbstractNode *)NULL;
    fr->abstractField = (AbstractField *)NULL;

    LLinkList_Init(&fr->fieldValueList);

    RWRETURN((fr));
}

void
FieldRec_Destroy(FieldRec * fr)
{
    RWFUNCTION(RWSTRING("FieldRec_Destroy"));

    RwFreeListFree(fieldRecFreeList, fr);

    RWRETURNVOID();
}
