/***************************************************************************
 *                                                                         *
 * Module  : ostypes.h                                                     *
 *                                                                         *
 * Purpose : Types                                                         *
 *                                                                         *
 **************************************************************************/

/* RWPUBLIC */
#ifndef SKY_OSTYPES_H
#define SKY_OSTYPES_H
/* RWPUBLICEND */

/****************************************************************************
 Includes
 */

/****************************************************************************
 Library version number
 */

/* RWPUBLIC */

#define rwLITTLEENDIAN         /* This is a little endian machine */

#include <eetypes.h>
#include <../gcc/ee/include/string.h>  /* prototypes for memcpy etc */

typedef int RwFixed;
typedef int RwInt32;
typedef unsigned int RwUInt32;
typedef short RwInt16;
typedef unsigned short RwUInt16;
typedef unsigned char RwUInt8;
typedef signed char RwInt8;

#ifdef RWUNICODE
typedef wchar_t RwChar;
#else /* RWUNICODE */
typedef char RwChar;
#endif /* RWUNICODE */
typedef float RwReal;
typedef RwInt32 RwBool;

/*
 * Fix for GCC 2.95.3
 * From README_SN2953.txt:
 * Version 1.00 - March '01
 * ------------
 * CAUTION - With this patch the GNU 'long long' type should not be used - 
 * use 'long' instead (it is also 64bits).
 */

#if (defined(__GNUC__) && defined (__LONG_MAX__))
#if ( 2147483647L < __LONG_MAX__)
typedef long RwInt64;
typedef unsigned long RwUInt64;
#else  /* ( 2147483647L < __LONG_MAX__ ) */
typedef long long RwInt64;
typedef unsigned long long RwUInt64;
#endif /* ( 2147483647L < __LONG_MAX__ ) */
#else  /* (defined(__GNUC__) && defined (__LONG_MAX__)) */
typedef long long RwInt64;
typedef unsigned long long RwUInt64;
#endif /* (defined(__GNUC__) && defined (__LONG_MAX__)) */

#define RWZERO64 ((RwUInt64)0)

typedef long128 RwInt128;
typedef u_long128 RwUInt128;
#define RWZERO128 ((RwUInt128)0)

/* Limits of types */
#define RwInt32MAXVAL       0x7FFFFFFF
#define RwInt32MINVAL       0x80000000
#define RwUInt32MAXVAL      0xFFFFFFFF
#define RwUInt32MINVAL      0x00000000
#define RwRealMAXVAL        (RwReal)(3.40282347e+38)
#define RwRealMINVAL        (RwReal)(1.17549435e-38)
#define RwInt16MAXVAL       0x7FFF
#define RwInt16MINVAL       0x8000
#define RwUInt16MAXVAL      0xFFFF
#define RwUInt16MINVAL      0x0000

/* Structure alignment */
#define RWALIGN(type, x)   type __attribute__((aligned(x)))

/* Stringification */

#define _SKY_STRINGIFY(_x) #_x
#define _SKY_EXPAND(_x) _SKY_STRINGIFY(_x)

#if defined (__MWERKS__)

#if (defined(RWVERBOSE))
#pragma message (__FILE__ "/" _SKY_EXPAND(__LINE__) ": __MWERKS__ == " _SKY_EXPAND(__MWERKS__))
#endif /* (defined (__MWERKS__)) */

#if ((!defined(RWSUPPRESSOPTIMIZATIONPRAGMAS)) && __option(global_optimizer))

/* #pragma inline_instrinsics on */
/* #pragma always_inline on */ /* seems to hang the compiler sometimes  */

#pragma auto_inline on
#pragma dont_inline off
#pragma inline_depth(smart)
#pragma opt_common_subs on
#pragma opt_dead_assignments on
#pragma opt_dead_code on
#pragma opt_lifetimes on
#pragma opt_loop_invariants on
#pragma opt_propagation on
#pragma opt_strength_reduction on
#pragma opt_unroll_loops on
#pragma opt_vectorize_loops on
#pragma peephole on

#if (0x2401 <= __MWERKS__)
#pragma fast_fptosi on
#pragma irocseglobaladdresses on
#endif /* (0x2401 <= __MWERKS__) */

#endif /* ((!defined(RWSUPPRESSOPTIMIZATIONPRAGMAS)) && __option(global_optimizer)) */

#if (defined(RW_USE_SPF))
#pragma float_constants on
#endif /* (defined(RW_USE_SPF)) */

#pragma extended_errorcheck on

#define rwMATRIXALIGNMENT 16
#define rwFRAMEALIGNMENT 16
#define rwV4DALIGNMENT 16

#endif /*  defined (__MWERKS__) */

#if (!defined(rwMATRIXALIGNMENT))
#define rwMATRIXALIGNMENT sizeof(RwUInt128)
#endif /* (!defined(rwMATRIXALIGNMENT)) */

#if (!defined(rwFRAMEALIGNMENT))
#define rwFRAMEALIGNMENT sizeof(RwUInt128)
#endif /* (!defined(rwFRAMEALIGNMENT)) */

#if (!defined(rwV4DALIGNMENT))
#define rwV4DALIGNMENT sizeof(RwUInt128)
#endif /* (!defined(rwV4DALIGNMENT)) */

#endif /* SKY_OSTYPES_H */

/* RWPUBLICEND */
